/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alarmcallbacks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.DBCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationAVImpl;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.alarmcallbacks.requests.CreateAlarmCallbackRequest;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;

public class AlarmCallbackConfigurationServiceMJImpl
implements AlarmCallbackConfigurationService {
    private final JacksonDBCollection<AlarmCallbackConfigurationAVImpl, String> coll;

    @Inject
    public AlarmCallbackConfigurationServiceMJImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapperProvider) {
        String collectionName = AlarmCallbackConfigurationAVImpl.class.getAnnotation(CollectionName.class).value();
        DBCollection dbCollection = mongoConnection.getDatabase().getCollection(collectionName);
        this.coll = JacksonDBCollection.wrap((DBCollection)dbCollection, AlarmCallbackConfigurationAVImpl.class, String.class, (ObjectMapper)mapperProvider.get());
    }

    @Override
    public List<AlarmCallbackConfiguration> getForStreamId(String streamId) {
        return this.toAbstractListType(this.coll.find(DBQuery.is((String)"stream_id", (Object)streamId)).toArray());
    }

    @Override
    public List<AlarmCallbackConfiguration> getForStream(Stream stream) {
        return this.getForStreamId(stream.getId());
    }

    @Override
    public AlarmCallbackConfiguration load(String alarmCallbackId) {
        return (AlarmCallbackConfiguration)this.coll.findOneById((Object)alarmCallbackId);
    }

    @Override
    public AlarmCallbackConfiguration create(String streamId, CreateAlarmCallbackRequest request, String userId) {
        return AlarmCallbackConfigurationAVImpl.create(new ObjectId().toHexString(), streamId, request.type, request.configuration, new Date(), userId);
    }

    @Override
    public long count() {
        return this.coll.count();
    }

    @Override
    public Map<String, Long> countPerType() {
        HashMap result = Maps.newHashMap();
        DBCursor avs = this.coll.find();
        for (AlarmCallbackConfigurationAVImpl av : avs) {
            Long count = (Long)result.get(av.getType());
            if (count == null) {
                count = 0L;
            }
            result.put(av.getType(), count + 1L);
        }
        return result;
    }

    @Override
    public String save(AlarmCallbackConfiguration model) throws ValidationException {
        return (String)this.coll.save((Object)this.implOrFail(model)).getSavedId();
    }

    @Override
    public int destroy(AlarmCallbackConfiguration model) {
        return this.coll.removeById((Object)model.getId()).getN();
    }

    private List<AlarmCallbackConfiguration> toAbstractListType(List<AlarmCallbackConfigurationAVImpl> callbacks) {
        ArrayList result = Lists.newArrayList();
        result.addAll(callbacks);
        return result;
    }

    private AlarmCallbackConfigurationAVImpl implOrFail(AlarmCallbackConfiguration callback) {
        if (callback instanceof AlarmCallbackConfigurationAVImpl) {
            AlarmCallbackConfigurationAVImpl callbackImpl = (AlarmCallbackConfigurationAVImpl)callback;
            return callbackImpl;
        }
        throw new IllegalArgumentException("Supplied output must be of implementation type AlarmCallbackConfigurationAVImpl, not " + callback.getClass());
    }
}

