/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.esplugin;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.graylog2.indexer.esplugin.IndicesClosedEvent;
import org.graylog2.indexer.esplugin.IndicesDeletedEvent;
import org.graylog2.indexer.esplugin.IndicesReopenedEvent;

public class IndexChangeMonitor
extends AbstractLifecycleComponent<IndexChangeMonitor>
implements ClusterStateListener {
    private static final EnumSet<ClusterState.ClusterStateStatus> VALID_CLUSTER_STATES = EnumSet.of(ClusterState.ClusterStateStatus.BEING_APPLIED, ClusterState.ClusterStateStatus.APPLIED);
    private static EventBus eventBus = null;
    private final ClusterService clusterService;

    @Inject
    public IndexChangeMonitor(Settings settings, ClusterService clusterService) {
        super(settings);
        this.clusterService = (ClusterService)Preconditions.checkNotNull((Object)clusterService);
    }

    public static void setEventBus(EventBus eventBus) {
        IndexChangeMonitor.eventBus = eventBus;
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (!VALID_CLUSTER_STATES.contains(event.state().status())) {
            return;
        }
        if (eventBus != null) {
            Set<String> indicesReopened;
            Set<String> indicesClosed;
            HashSet<String> indicesDeleted = new HashSet<String>(event.indicesDeleted());
            if (!indicesDeleted.isEmpty()) {
                eventBus.post((Object)IndicesDeletedEvent.create(indicesDeleted));
            }
            if (!(indicesClosed = this.calculateClosedIndices(event.state(), event.previousState())).isEmpty()) {
                eventBus.post((Object)IndicesClosedEvent.create(indicesClosed));
            }
            if (!(indicesReopened = this.calculateReopenedIndices(event.state(), event.previousState())).isEmpty()) {
                eventBus.post((Object)IndicesReopenedEvent.create(indicesReopened));
            }
        }
    }

    private Set<String> calculateClosedIndices(ClusterState currentState, @Nullable ClusterState previousState) {
        if (previousState == null || previousState.metaData() == currentState.metaData()) {
            return Collections.emptySet();
        }
        HashSet<String> currentClosedIndices = this.getClosedIndices(currentState.getMetaData());
        HashSet<String> previousClosedIndices = this.getClosedIndices(previousState.getMetaData());
        return Sets.difference(currentClosedIndices, previousClosedIndices);
    }

    private Set<String> calculateReopenedIndices(ClusterState currentState, @Nullable ClusterState previousState) {
        if (previousState == null || previousState.metaData() == currentState.metaData()) {
            return Collections.emptySet();
        }
        HashSet<String> currentClosedIndices = this.getClosedIndices(currentState.getMetaData());
        HashSet<String> previousClosedIndices = this.getClosedIndices(previousState.getMetaData());
        return Sets.difference(previousClosedIndices, currentClosedIndices);
    }

    private HashSet<String> getClosedIndices(MetaData currentMetaData) {
        return new HashSet<String>(Arrays.asList(currentMetaData.concreteAllClosedIndices()));
    }

    protected void doStart() throws ElasticsearchException {
        this.clusterService.add((ClusterStateListener)this);
    }

    protected void doStop() throws ElasticsearchException {
        this.clusterService.remove((ClusterStateListener)this);
    }

    protected void doClose() throws ElasticsearchException {
    }
}

