/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.retention.strategies;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.graylog2.auditlog.AuditLogger;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.IndexHelper;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.periodical.IndexRetentionThread;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexCountBasedRetentionStrategy
implements RetentionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIndexCountBasedRetentionStrategy.class);
    private final Deflector deflector;
    private final Indices indices;
    private final ActivityWriter activityWriter;
    private final AuditLogger auditLogger;

    public AbstractIndexCountBasedRetentionStrategy(Deflector deflector, Indices indices, ActivityWriter activityWriter, AuditLogger auditLogger) {
        this.deflector = Objects.requireNonNull(deflector);
        this.indices = Objects.requireNonNull(indices);
        this.activityWriter = Objects.requireNonNull(activityWriter);
        this.auditLogger = Objects.requireNonNull(auditLogger);
    }

    protected abstract Optional<Integer> getMaxNumberOfIndices();

    protected abstract void retain(String var1);

    @Override
    public void retain() {
        Map<String, Set<String>> deflectorIndices = this.deflector.getAllGraylogDeflectorIndices();
        int indexCount = deflectorIndices.size();
        Optional<Integer> maxIndices = this.getMaxNumberOfIndices();
        if (!maxIndices.isPresent()) {
            LOG.warn("No retention strategy configuration found, not running index retention!");
            return;
        }
        if (indexCount <= maxIndices.get()) {
            LOG.debug("Number of indices ({}) lower than limit ({}). Not performing any retention actions.", (Object)indexCount, (Object)maxIndices.get());
            return;
        }
        int removeCount = indexCount - maxIndices.get();
        String msg = "Number of indices (" + indexCount + ") higher than limit (" + maxIndices.get() + "). " + "Running retention for " + removeCount + " indices.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
        ImmutableMap auditLogContext = ImmutableMap.of((Object)"retention_strategy", (Object)this.getClass().getCanonicalName());
        this.auditLogger.success("<system>", "initiated", "index retention", (Map<String, Object>)auditLogContext);
        this.runRetention(deflectorIndices, removeCount);
    }

    private void runRetention(Map<String, Set<String>> deflectorIndices, int removeCount) {
        for (String indexName : IndexHelper.getOldestIndices(deflectorIndices.keySet(), removeCount)) {
            if (deflectorIndices.get(indexName).contains(this.deflector.getName())) {
                LOG.info("Not running retention against current deflector target <{}>.", (Object)indexName);
                continue;
            }
            if (this.indices.isReopened(indexName)) {
                LOG.info("Not running retention against reopened index <{}>.", (Object)indexName);
                continue;
            }
            String strategyName = this.getClass().getCanonicalName();
            String msg = "Running retention strategy [" + strategyName + "] for index <" + indexName + ">";
            LOG.info(msg);
            this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
            this.retain(indexName);
            ImmutableMap auditLogContext = ImmutableMap.of((Object)"index_name", (Object)indexName, (Object)"retention_strategy", (Object)strategyName);
            this.auditLogger.success("<system>", "completed", "index retention", (Map<String, Object>)auditLogContext);
        }
    }
}

