/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog2.plugin.inputs.Converter;

public class TokenizerConverter
extends Converter {
    private static final Pattern PATTERN = Pattern.compile("(?:^|\\s)(?:([\\w-]+)\\s?=\\s?((?:\"[^\"]+\")|(?:'[^']+')|(?:[\\S]+)))");

    public TokenizerConverter(Map<String, Object> config) {
        super(Converter.Type.TOKENIZER, config);
    }

    @Override
    public Object convert(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        if (value.contains("=")) {
            ImmutableMap.Builder fields = ImmutableMap.builder();
            Matcher m = PATTERN.matcher(value);
            while (m.find()) {
                if (m.groupCount() != 2) continue;
                fields.put((Object)this.removeQuotes(m.group(1)), (Object)this.removeQuotes(m.group(2)));
            }
            return fields.build();
        }
        return Collections.emptyMap();
    }

    private String removeQuotes(String s) {
        if (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    @Override
    public boolean buildsMultipleFields() {
        return true;
    }
}

