/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.notifications;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bson.types.ObjectId;
import org.graylog2.cluster.Node;
import org.graylog2.database.CollectionName;
import org.graylog2.database.PersistedImpl;
import org.graylog2.notifications.Notification;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.validators.Validator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CollectionName(value="notifications")
public class NotificationImpl
extends PersistedImpl
implements Notification {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationImpl.class);
    private Notification.Type type;
    private Notification.Severity severity;
    private DateTime timestamp;
    private String node_id;

    protected NotificationImpl(ObjectId id, Map<String, Object> fields) {
        super(id, fields);
        this.type = Notification.Type.valueOf(((String)fields.get("type")).toUpperCase(Locale.ENGLISH));
        this.severity = Notification.Severity.valueOf(((String)fields.get("severity")).toUpperCase(Locale.ENGLISH));
        this.timestamp = new DateTime(fields.get("timestamp"), DateTimeZone.UTC);
        this.node_id = (String)fields.get("node_id");
    }

    protected NotificationImpl(Map<String, Object> fields) {
        super(fields);
        this.type = Notification.Type.valueOf(((String)fields.get("type")).toUpperCase(Locale.ENGLISH));
        this.severity = Notification.Severity.valueOf(((String)fields.get("severity")).toUpperCase(Locale.ENGLISH));
        this.timestamp = new DateTime(fields.get("timestamp"), DateTimeZone.UTC);
        this.node_id = (String)fields.get("node_id");
    }

    public NotificationImpl() {
        super(new HashMap<String, Object>());
    }

    @Override
    public Notification addType(Notification.Type type) {
        this.type = type;
        this.fields.put("type", type.toString().toLowerCase(Locale.ENGLISH));
        return this;
    }

    @Override
    public Notification addTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
        this.fields.put("timestamp", Tools.getISO8601String(timestamp));
        return this;
    }

    @Override
    public Notification addSeverity(Notification.Severity severity) {
        this.severity = severity;
        this.fields.put("severity", severity.toString().toLowerCase(Locale.ENGLISH));
        return this;
    }

    @Override
    public Notification addNode(Node node) {
        return this.addNode(node.getNodeId());
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Notification.Type getType() {
        return this.type;
    }

    @Override
    public Notification.Severity getSeverity() {
        return this.severity;
    }

    @Override
    public String getNodeId() {
        return this.node_id;
    }

    @Override
    public Notification addDetail(String key, Object value) {
        if (this.fields.get("details") == null) {
            this.fields.put("details", new HashMap());
        }
        Map details = (Map)this.fields.get("details");
        details.put(key, value);
        return this;
    }

    @Override
    public Object getDetail(String key) {
        Map details = (Map)this.fields.get("details");
        if (details == null) {
            return null;
        }
        return details.get(key);
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap result = Maps.newHashMap((Map)this.fields);
        result.remove("_id");
        return result;
    }

    @Override
    public Notification addNode(String nodeId) {
        this.fields.put("node_id", nodeId);
        return this;
    }

    @Override
    public Map<String, Validator> getValidations() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Validator> getEmbeddedValidations(String key) {
        return Collections.emptyMap();
    }
}

