/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import java.util.List;
import javax.inject.Inject;
import org.graylog2.Configuration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.alarmcallbacks.AlarmCallbackFactory;
import org.graylog2.alarmcallbacks.AlarmCallbackHistory;
import org.graylog2.alarmcallbacks.AlarmCallbackHistoryService;
import org.graylog2.alarmcallbacks.EmailAlarmCallback;
import org.graylog2.alerts.Alert;
import org.graylog2.alerts.AlertService;
import org.graylog2.initializers.IndexerSetupService;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertScannerThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(AlertScannerThread.class);
    private final StreamService streamService;
    private final AlarmCallbackConfigurationService alarmCallbackConfigurationService;
    private final AlarmCallbackFactory alarmCallbackFactory;
    private final EmailAlarmCallback emailAlarmCallback;
    private final IndexerSetupService indexerSetupService;
    private final AlertService alertService;
    private final Configuration configuration;
    private final AlarmCallbackHistoryService alarmCallbackHistoryService;

    @Inject
    public AlertScannerThread(AlertService alertService, StreamService streamService, AlarmCallbackConfigurationService alarmCallbackConfigurationService, AlarmCallbackFactory alarmCallbackFactory, EmailAlarmCallback emailAlarmCallback, IndexerSetupService indexerSetupService, Configuration configuration, AlarmCallbackHistoryService alarmCallbackHistoryService) {
        this.alertService = alertService;
        this.streamService = streamService;
        this.alarmCallbackConfigurationService = alarmCallbackConfigurationService;
        this.alarmCallbackFactory = alarmCallbackFactory;
        this.emailAlarmCallback = emailAlarmCallback;
        this.indexerSetupService = indexerSetupService;
        this.configuration = configuration;
        this.alarmCallbackHistoryService = alarmCallbackHistoryService;
    }

    @Override
    public void doRun() {
        if (!this.indexerSetupService.isRunning()) {
            LOG.error("Indexer is not running, not checking streams for alerts.");
            return;
        }
        LOG.debug("Running alert checks.");
        List<Stream> alertedStreams = this.streamService.loadAllWithConfiguredAlertConditions();
        LOG.debug("There are {}\u00a0streams with configured alert conditions.", (Object)alertedStreams.size());
        for (Stream stream : alertedStreams) {
            LOG.debug("Stream [{}] has [{}] configured alert conditions.", (Object)stream, (Object)this.streamService.getAlertConditions(stream).size());
            if (stream.isPaused().booleanValue()) {
                LOG.debug("Stream [{}] has been paused. Skipping alert check.", (Object)stream);
                continue;
            }
            for (AlertCondition alertCondition : this.streamService.getAlertConditions(stream)) {
                try {
                    AlertCondition.CheckResult result = this.alertService.triggered(alertCondition);
                    if (result.isTriggered()) {
                        LOG.debug("Alert condition [{}] is triggered. Sending alerts.", (Object)alertCondition);
                        Alert alert = this.alertService.factory(result);
                        this.alertService.save(alert);
                        List<AlarmCallbackConfiguration> callConfigurations = this.alarmCallbackConfigurationService.getForStream(stream);
                        if (callConfigurations.size() > 0) {
                            for (AlarmCallbackConfiguration configuration : callConfigurations) {
                                AlarmCallbackHistory alarmCallbackHistory;
                                AlarmCallback alarmCallback = null;
                                try {
                                    alarmCallback = this.alarmCallbackFactory.create(configuration);
                                    alarmCallback.call(stream, result);
                                    alarmCallbackHistory = this.alarmCallbackHistoryService.success(configuration, alert, alertCondition);
                                }
                                catch (Exception e) {
                                    if (alarmCallback != null) {
                                        LOG.warn("Alarm callback <" + alarmCallback.getName() + "> failed. Skipping.", (Throwable)e);
                                    } else {
                                        LOG.warn("Alarm callback with id " + configuration.getId() + " failed. Skipping.", (Throwable)e);
                                    }
                                    alarmCallbackHistory = this.alarmCallbackHistoryService.error(configuration, alert, alertCondition, e.getMessage());
                                }
                                try {
                                    this.alarmCallbackHistoryService.save(alarmCallbackHistory);
                                }
                                catch (Exception e) {
                                    LOG.warn("Unable to save history of alarm callback run: ", (Throwable)e);
                                }
                            }
                            continue;
                        }
                        this.emailAlarmCallback.call(stream, result);
                        continue;
                    }
                    LOG.debug("Alert condition [{}]\u00a0is not triggered.", (Object)alertCondition);
                }
                catch (Exception e) {
                    LOG.error("Skipping alert check that threw an exception.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 10;
    }

    @Override
    public int getPeriodSeconds() {
        return this.configuration.getAlertCheckInterval();
    }
}

