/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import javax.inject.Inject;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.management.IndexManagementConfig;
import org.graylog2.indexer.retention.strategies.ClosingRetentionStrategy;
import org.graylog2.indexer.retention.strategies.ClosingRetentionStrategyConfig;
import org.graylog2.indexer.retention.strategies.DeletionRetentionStrategy;
import org.graylog2.indexer.retention.strategies.DeletionRetentionStrategyConfig;
import org.graylog2.indexer.rotation.strategies.MessageCountRotationStrategy;
import org.graylog2.indexer.rotation.strategies.MessageCountRotationStrategyConfig;
import org.graylog2.indexer.rotation.strategies.SizeBasedRotationStrategy;
import org.graylog2.indexer.rotation.strategies.SizeBasedRotationStrategyConfig;
import org.graylog2.indexer.rotation.strategies.TimeBasedRotationStrategy;
import org.graylog2.indexer.rotation.strategies.TimeBasedRotationStrategyConfig;
import org.graylog2.indexer.searches.SearchesClusterConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManagementPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationManagementPeriodical.class);
    private final ElasticsearchConfiguration elasticsearchConfiguration;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public ConfigurationManagementPeriodical(ElasticsearchConfiguration elasticsearchConfiguration, ClusterConfigService clusterConfigService) {
        this.elasticsearchConfiguration = elasticsearchConfiguration;
        this.clusterConfigService = clusterConfigService;
    }

    public void migrateElasticsearchConfig() {
        SearchesClusterConfig searchesClusterConfig;
        IndexManagementConfig indexManagementConfig;
        MessageCountRotationStrategyConfig messageCountRotationStrategyConfig = this.clusterConfigService.get(MessageCountRotationStrategyConfig.class);
        SizeBasedRotationStrategyConfig sizeBasedRotationStrategyConfig = this.clusterConfigService.get(SizeBasedRotationStrategyConfig.class);
        TimeBasedRotationStrategyConfig timeBasedRotationStrategyConfig = this.clusterConfigService.get(TimeBasedRotationStrategyConfig.class);
        if (messageCountRotationStrategyConfig == null) {
            MessageCountRotationStrategyConfig countConfig = MessageCountRotationStrategyConfig.create(this.elasticsearchConfiguration.getMaxDocsPerIndex());
            this.clusterConfigService.write(countConfig);
            LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_docs_per_index", (Object)countConfig);
        }
        if (sizeBasedRotationStrategyConfig == null) {
            SizeBasedRotationStrategyConfig sizeConfig = SizeBasedRotationStrategyConfig.create(this.elasticsearchConfiguration.getMaxSizePerIndex());
            this.clusterConfigService.write(sizeConfig);
            LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_size_per_index", (Object)sizeConfig);
        }
        if (timeBasedRotationStrategyConfig == null) {
            TimeBasedRotationStrategyConfig timeConfig = TimeBasedRotationStrategyConfig.create(this.elasticsearchConfiguration.getMaxTimePerIndex());
            this.clusterConfigService.write(timeConfig);
            LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_time_per_index", (Object)timeConfig);
        }
        ClosingRetentionStrategyConfig closingRetentionStrategyConfig = this.clusterConfigService.get(ClosingRetentionStrategyConfig.class);
        DeletionRetentionStrategyConfig deletionRetentionStrategyConfig = this.clusterConfigService.get(DeletionRetentionStrategyConfig.class);
        if (closingRetentionStrategyConfig == null) {
            ClosingRetentionStrategyConfig closingConfig = ClosingRetentionStrategyConfig.create(this.elasticsearchConfiguration.getMaxNumberOfIndices());
            this.clusterConfigService.write(closingConfig);
            LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_number_of_indices", (Object)closingConfig);
        }
        if (deletionRetentionStrategyConfig == null) {
            DeletionRetentionStrategyConfig deletionConfig = DeletionRetentionStrategyConfig.create(this.elasticsearchConfiguration.getMaxNumberOfIndices());
            this.clusterConfigService.write(deletionConfig);
            LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_number_of_indices", (Object)deletionConfig);
        }
        if ((indexManagementConfig = this.clusterConfigService.get(IndexManagementConfig.class)) == null) {
            Class retentionStrategyClass;
            Class rotationStrategyClass;
            switch (this.elasticsearchConfiguration.getRotationStrategy()) {
                case "size": {
                    rotationStrategyClass = SizeBasedRotationStrategy.class;
                    break;
                }
                case "time": {
                    rotationStrategyClass = TimeBasedRotationStrategy.class;
                    break;
                }
                case "count": {
                    rotationStrategyClass = MessageCountRotationStrategy.class;
                    break;
                }
                default: {
                    LOG.warn("Unknown retention strategy \"{}\"", (Object)this.elasticsearchConfiguration.getRotationStrategy());
                    rotationStrategyClass = MessageCountRotationStrategy.class;
                }
            }
            switch (this.elasticsearchConfiguration.getRetentionStrategy()) {
                case "close": {
                    retentionStrategyClass = ClosingRetentionStrategy.class;
                    break;
                }
                case "delete": {
                    retentionStrategyClass = DeletionRetentionStrategy.class;
                    break;
                }
                default: {
                    LOG.warn("Unknown retention strategy \"{}\"", (Object)this.elasticsearchConfiguration.getRetentionStrategy());
                    retentionStrategyClass = DeletionRetentionStrategy.class;
                }
            }
            IndexManagementConfig config = IndexManagementConfig.create(rotationStrategyClass.getCanonicalName(), retentionStrategyClass.getCanonicalName());
            this.clusterConfigService.write(config);
            LOG.info("Migrated \"{}\" and \"{}\" setting: {}", new Object[]{"rotation_strategy", "retention_strategy", config});
        }
        if ((searchesClusterConfig = this.clusterConfigService.get(SearchesClusterConfig.class)) == null) {
            SearchesClusterConfig config = SearchesClusterConfig.createDefault();
            LOG.info("Creating searches cluster config: {}", (Object)config);
            this.clusterConfigService.write(config);
        }
    }

    @Override
    public void doRun() {
        this.migrateElasticsearchConfig();
    }

    @Override
    public boolean runsForever() {
        return true;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

