/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.ProcessingPauseLockedException;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.lifecycles.Lifecycle;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.SuppressForbidden;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ServerStatus {
    private static final Logger LOG = LoggerFactory.getLogger(ServerStatus.class);
    private final EventBus eventBus;
    private final NodeId nodeId;
    private final String clusterId;
    private final DateTime startedAt;
    private final Set<Capability> capabilitySet;
    private MessageDetailRecordingStrategy messageDetailRecordingStrategy = MessageDetailRecordingStrategy.NEVER;
    private final AtomicBoolean isProcessing = new AtomicBoolean(false);
    private final AtomicBoolean processingPauseLocked = new AtomicBoolean(false);
    private final CountDownLatch runningLatch = new CountDownLatch(1);
    private volatile Lifecycle lifecycle = Lifecycle.UNINITIALIZED;

    public MessageDetailRecordingStrategy getDetailedMessageRecordingStrategy() {
        return this.messageDetailRecordingStrategy;
    }

    @Inject
    public ServerStatus(BaseConfiguration configuration, Set<Capability> capabilities, EventBus eventBus) {
        this.eventBus = eventBus;
        this.nodeId = new NodeId(configuration.getNodeIdFile());
        this.clusterId = "";
        this.startedAt = Tools.nowUTC();
        this.capabilitySet = Sets.newHashSet(capabilities);
        this.messageDetailRecordingStrategy = configuration.isMessageRecordingsEnabled() ? MessageDetailRecordingStrategy.ALWAYS : MessageDetailRecordingStrategy.NEVER;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    private void publishLifecycle(Lifecycle lifecycle) {
        this.setLifecycle(lifecycle);
        this.eventBus.post((Object)lifecycle);
    }

    private void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void initialize() {
        this.publishLifecycle(Lifecycle.STARTING);
    }

    public void start() {
        this.isProcessing.set(true);
        this.runningLatch.countDown();
        this.publishLifecycle(Lifecycle.RUNNING);
    }

    public void shutdown(boolean forceProcessing) {
        if (forceProcessing) {
            this.unlockProcessingPause();
            this.isProcessing.set(true);
        }
        this.publishLifecycle(Lifecycle.HALTING);
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void fail() {
        this.isProcessing.set(false);
        this.publishLifecycle(Lifecycle.FAILED);
    }

    public void throttle() {
        this.publishLifecycle(Lifecycle.THROTTLED);
    }

    public void running() {
        this.publishLifecycle(Lifecycle.RUNNING);
    }

    public void overrideLoadBalancerDead() {
        this.publishLifecycle(Lifecycle.OVERRIDE_LB_DEAD);
    }

    public void overrideLoadBalancerAlive() {
        this.publishLifecycle(Lifecycle.OVERRIDE_LB_ALIVE);
    }

    public void overrideLoadBalancerThrottled() {
        this.publishLifecycle(Lifecycle.OVERRIDE_LB_THROTTLED);
    }

    public void awaitRunning(Runnable runnable) {
        LOG.debug("Waiting for server to enter RUNNING state");
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.runningLatch);
        LOG.debug("Server entered RUNNING state");
        try {
            LOG.debug("Executing awaitRunning callback");
            runnable.run();
        }
        catch (Exception e) {
            LOG.error("awaitRunning callback failed", (Throwable)e);
        }
    }

    public DateTime getStartedAt() {
        return this.startedAt;
    }

    @SuppressForbidden(value="Deliberate invocation")
    public DateTimeZone getTimezone() {
        return DateTimeZone.getDefault();
    }

    public ServerStatus addCapability(Capability capability) {
        this.capabilitySet.add(capability);
        return this;
    }

    public ServerStatus addCapabilities(Capability ... capabilities) {
        this.capabilitySet.addAll(Arrays.asList(capabilities));
        return this;
    }

    public boolean hasCapability(Capability capability) {
        return this.capabilitySet.contains((Object)capability);
    }

    public boolean hasCapabilities(Capability ... capabilities) {
        return this.capabilitySet.containsAll(Arrays.asList(capabilities));
    }

    public boolean isProcessing() {
        return this.isProcessing.get();
    }

    public void pauseMessageProcessing() {
        this.pauseMessageProcessing(true);
    }

    public void pauseMessageProcessing(boolean locked) {
        this.processingPauseLocked.compareAndSet(false, locked);
        this.isProcessing.set(false);
        this.publishLifecycle(Lifecycle.PAUSED);
    }

    public void resumeMessageProcessing() throws ProcessingPauseLockedException {
        if (this.processingPauseLocked()) {
            throw new ProcessingPauseLockedException("Processing pause is locked. Wait until the locking task has finished or manually unlock if you know what you are doing.");
        }
        this.start();
    }

    public boolean processingPauseLocked() {
        return this.processingPauseLocked.get();
    }

    public void unlockProcessingPause() {
        this.processingPauseLocked.set(false);
    }

    private ServerStatus removeCapability(Capability capability) {
        this.capabilitySet.remove((Object)capability);
        return this;
    }

    public void setLocalMode(boolean localMode) {
        if (localMode) {
            this.addCapability(Capability.LOCALMODE);
        } else {
            this.removeCapability(Capability.LOCALMODE);
        }
    }

    public static enum MessageDetailRecordingStrategy {
        NEVER,
        ALWAYS;


        public boolean shouldRecord(Message message) {
            switch (this) {
                case NEVER: {
                    return false;
                }
                case ALWAYS: {
                    return true;
                }
            }
            return false;
        }
    }

    public static enum Capability {
        SERVER,
        MASTER,
        LOCALMODE;

    }
}

