/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inject;

import com.google.common.util.concurrent.Service;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.graylog2.auditlog.AuditLogger;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;
import org.graylog2.plugin.decorators.SearchResponseDecorator;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.security.PasswordAlgorithm;
import org.graylog2.plugin.security.PluginPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Graylog2Module
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(Graylog2Module.class);

    protected void installTransport(MapBinder<String, Transport.Factory<? extends Transport>> mapBinder, String name, Class<? extends Transport> transportClass) {
        Class<?> configClass = this.findInnerClassAnnotatedWith(ConfigClass.class, transportClass, Transport.Config.class);
        Class<?> factoryClass = this.findInnerClassAnnotatedWith(FactoryClass.class, transportClass, Transport.Factory.class);
        if (configClass == null) {
            LOG.error("Unable to find an inner class annotated with @ConfigClass in transport {}. This transport will not be available!", transportClass);
            return;
        }
        if (factoryClass == null) {
            LOG.error("Unable to find an inner class annotated with @FactoryClass in transport {}. This transport will not be available!", transportClass);
            return;
        }
        this.installTransport(mapBinder, name, transportClass, configClass, factoryClass);
    }

    protected void installTransport(MapBinder<String, Transport.Factory<? extends Transport>> mapBinder, String name, Class<? extends Transport> transportClass, Class<? extends Transport.Config> configClass, Class<? extends Transport.Factory<? extends Transport>> factoryClass) {
        Key factoryKey = Key.get(factoryClass);
        this.install(new FactoryModuleBuilder().implement(Transport.class, transportClass).implement(Transport.Config.class, configClass).build(factoryClass));
        mapBinder.addBinding((Object)name).to(factoryKey);
    }

    protected void installCodec(MapBinder<String, Codec.Factory<? extends Codec>> mapBinder, Class<? extends Codec> codecClass) {
        if (codecClass.isAnnotationPresent(org.graylog2.plugin.inputs.annotations.Codec.class)) {
            org.graylog2.plugin.inputs.annotations.Codec a = codecClass.getAnnotation(org.graylog2.plugin.inputs.annotations.Codec.class);
            this.installCodec(mapBinder, a.name(), codecClass);
        } else {
            LOG.error("Codec {} not annotated with {}. Cannot determine its id. This is a bug, please use that annotation, this codec will not be available", codecClass, org.graylog2.plugin.inputs.annotations.Codec.class);
        }
    }

    protected void installCodec(MapBinder<String, Codec.Factory<? extends Codec>> mapBinder, String name, Class<? extends Codec> codecClass) {
        Class<?> configClass = this.findInnerClassAnnotatedWith(ConfigClass.class, codecClass, Codec.Config.class);
        Class<?> factoryClass = this.findInnerClassAnnotatedWith(FactoryClass.class, codecClass, Codec.Factory.class);
        if (configClass == null) {
            LOG.error("Unable to find an inner class annotated with @ConfigClass in codec {}. This codec will not be available!", codecClass);
            return;
        }
        if (factoryClass == null) {
            LOG.error("Unable to find an inner class annotated with @FactoryClass in codec {}. This codec will not be available!", codecClass);
            return;
        }
        this.installCodec(mapBinder, name, codecClass, configClass, factoryClass);
    }

    protected void installCodec(MapBinder<String, Codec.Factory<? extends Codec>> mapBinder, String name, Class<? extends Codec> codecClass, Class<? extends Codec.Config> configClass, Class<? extends Codec.Factory<? extends Codec>> factoryClass) {
        Key factoryKey = Key.get(factoryClass);
        this.install(new FactoryModuleBuilder().implement(Codec.class, codecClass).implement(Codec.Config.class, configClass).build(factoryClass));
        mapBinder.addBinding((Object)name).to(factoryKey);
    }

    @Nullable
    protected Class<?> findInnerClassAnnotatedWith(Class<? extends Annotation> annotationClass, Class<?> containingClass, Class<?> targetClass) {
        Class<?>[] declaredClasses = containingClass.getDeclaredClasses();
        Class<?> annotatedClass = null;
        for (Class<?> declaredClass : declaredClasses) {
            if (!declaredClass.isAnnotationPresent(annotationClass)) continue;
            if (targetClass.isAssignableFrom(declaredClass)) {
                if (annotatedClass != null) {
                    LOG.error("Multiple annotations for {} found in {}. This is invalid.", (Object)annotatedClass.getSimpleName(), containingClass);
                    return null;
                }
                annotatedClass = declaredClass;
                continue;
            }
            LOG.error("{} annotated as {} is not extending the expected {}. Did you forget to implement the correct interface?", new Object[]{declaredClass, annotationClass.getSimpleName(), targetClass});
            return null;
        }
        return annotatedClass;
    }

    protected MapBinder<String, Codec.Factory<? extends Codec>> codecMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<Codec.Factory<? extends Codec>>(){});
    }

    protected MapBinder<String, Transport.Factory<? extends Transport>> transportMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<Transport.Factory<? extends Transport>>(){});
    }

    protected MapBinder<String, MessageInput.Factory<? extends MessageInput>> inputsMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<MessageInput.Factory<? extends MessageInput>>(){});
    }

    protected MapBinder<String, RotationStrategy> rotationStrategiesMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, RotationStrategy.class);
    }

    protected MapBinder<String, RetentionStrategy> retentionStrategyMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, RetentionStrategy.class);
    }

    protected void installRotationStrategy(MapBinder<String, RotationStrategy> mapBinder, Class<? extends RotationStrategy> target) {
        mapBinder.addBinding((Object)target.getCanonicalName()).to(target);
    }

    protected void installRetentionStrategy(MapBinder<String, RetentionStrategy> mapBinder, Class<? extends RetentionStrategy> target) {
        mapBinder.addBinding((Object)target.getCanonicalName()).to(target);
    }

    protected <T extends MessageInput> void installInput(MapBinder<String, MessageInput.Factory<? extends MessageInput>> inputMapBinder, Class<T> target, Class<? extends MessageInput.Factory<T>> targetFactory) {
        this.install(new FactoryModuleBuilder().implement(MessageInput.class, target).build(targetFactory));
        inputMapBinder.addBinding((Object)target.getCanonicalName()).to(Key.get(targetFactory));
    }

    protected <T extends MessageInput> void installInput(MapBinder<String, MessageInput.Factory<? extends MessageInput>> inputMapBinder, Class<T> target) {
        Class<?> factoryClass = this.findInnerClassAnnotatedWith(FactoryClass.class, target, MessageInput.Factory.class);
        if (factoryClass == null) {
            LOG.error("Unable to find an inner class annotated with @FactoryClass in input {}. This input will not be available!", target);
            return;
        }
        this.installInput(inputMapBinder, target, factoryClass);
    }

    protected MapBinder<String, MessageOutput.Factory<? extends MessageOutput>> outputsMapBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<MessageOutput.Factory<? extends MessageOutput>>(){});
    }

    protected <T extends MessageOutput> void installOutput(MapBinder<String, MessageOutput.Factory<? extends MessageOutput>> outputMapBinder, Class<T> target, Class<? extends MessageOutput.Factory<T>> targetFactory) {
        this.install(new FactoryModuleBuilder().implement(MessageOutput.class, target).build(targetFactory));
        outputMapBinder.addBinding((Object)target.getCanonicalName()).to(Key.get(targetFactory));
    }

    protected <T extends MessageOutput> void installOutput(MapBinder<String, MessageOutput.Factory<? extends MessageOutput>> outputMapBinder, Class<T> target) {
        Class<?> factoryClass = this.findInnerClassAnnotatedWith(FactoryClass.class, target, MessageOutput.Factory.class);
        if (factoryClass == null) {
            LOG.error("Unable to find an inner class annotated with @FactoryClass in output {}. This output will not be available!", target);
            return;
        }
        this.installOutput(outputMapBinder, target, factoryClass);
    }

    protected MapBinder<String, WidgetStrategy.Factory<? extends WidgetStrategy>> widgetStrategyBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<WidgetStrategy.Factory<? extends WidgetStrategy>>(){});
    }

    protected void installWidgetStrategy(MapBinder<String, WidgetStrategy.Factory<? extends WidgetStrategy>> widgetStrategyBinder, Class<? extends WidgetStrategy> target, Class<? extends WidgetStrategy.Factory<? extends WidgetStrategy>> targetFactory) {
        this.install(new FactoryModuleBuilder().implement(WidgetStrategy.class, target).build(targetFactory));
        widgetStrategyBinder.addBinding((Object)target.getCanonicalName()).to(Key.get(targetFactory));
    }

    protected void installWidgetStrategyWithAlias(MapBinder<String, WidgetStrategy.Factory<? extends WidgetStrategy>> widgetStrategyBinder, String key, Class<? extends WidgetStrategy> target, Class<? extends WidgetStrategy.Factory<? extends WidgetStrategy>> targetFactory) {
        this.installWidgetStrategy(widgetStrategyBinder, target, targetFactory);
        widgetStrategyBinder.addBinding((Object)key).to(Key.get(targetFactory));
    }

    protected Multibinder<PluginPermissions> permissionsBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), PluginPermissions.class);
    }

    protected void installPermissions(Multibinder<PluginPermissions> classMultibinder, Class<? extends PluginPermissions> permissionsClass) {
        classMultibinder.addBinding().to(permissionsClass);
    }

    @Nonnull
    protected Multibinder<Class<? extends DynamicFeature>> jerseyDynamicFeatureBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new DynamicFeatureType());
    }

    @Nonnull
    protected Multibinder<Class<? extends ContainerResponseFilter>> jerseyContainerResponseFilterBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new ContainerResponseFilterType());
    }

    @Nonnull
    protected Multibinder<Class<? extends ExceptionMapper>> jerseyExceptionMapperBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new ExceptionMapperType());
    }

    @Nonnull
    protected Multibinder<Class> jerseyAdditionalComponentsBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), Class.class, (Annotation)Names.named((String)"additionalJerseyComponents"));
    }

    protected Multibinder<Service> serviceBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), Service.class);
    }

    protected MapBinder<String, PasswordAlgorithm> passwordAlgorithmBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, PasswordAlgorithm.class);
    }

    protected MapBinder<String, AuthenticatingRealm> authenticationRealmBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, AuthenticatingRealm.class);
    }

    protected MapBinder<String, SearchResponseDecorator.Factory> searchResponseDecoratorBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), String.class, SearchResponseDecorator.Factory.class);
    }

    protected void installSearchResponseDecorator(MapBinder<String, SearchResponseDecorator.Factory> searchResponseDecoratorBinder, Class<? extends SearchResponseDecorator> searchResponseDecoratorClass, Class<? extends SearchResponseDecorator.Factory> searchResponseDecoratorFactoryClass) {
        this.install(new FactoryModuleBuilder().implement(SearchResponseDecorator.class, searchResponseDecoratorClass).build(searchResponseDecoratorFactoryClass));
        searchResponseDecoratorBinder.addBinding((Object)searchResponseDecoratorClass.getCanonicalName()).to(searchResponseDecoratorFactoryClass);
    }

    protected OptionalBinder<AuditLogger> auditLoggerBinder() {
        return OptionalBinder.newOptionalBinder((Binder)this.binder(), AuditLogger.class);
    }

    private static class ExceptionMapperType
    extends TypeLiteral<Class<? extends ExceptionMapper>> {
        private ExceptionMapperType() {
        }
    }

    private static class ContainerResponseFilterType
    extends TypeLiteral<Class<? extends ContainerResponseFilter>> {
        private ContainerResponseFilterType() {
        }
    }

    private static class DynamicFeatureType
    extends TypeLiteral<Class<? extends DynamicFeature>> {
        private DynamicFeatureType() {
        }
    }
}

