/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.streams;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum StreamRuleType {
    EXACT(1, "match exactly", "match exactly"),
    REGEX(2, "match regular expression", "match regular expression"),
    GREATER(3, "greater than", "be greater than"),
    SMALLER(4, "smaller than", "be smaller than"),
    PRESENCE(5, "field presence", "be present");

    private final int value;
    private final String shortDesc;
    private final String longDesc;

    private StreamRuleType(int value, String shortDesc, String longDesc) {
        this.value = value;
        this.shortDesc = shortDesc;
        this.longDesc = longDesc;
    }

    public int toInteger() {
        return this.value;
    }

    public static StreamRuleType fromInteger(int numeric) {
        for (StreamRuleType streamRuleType : StreamRuleType.values()) {
            if (streamRuleType.value != numeric) continue;
            return streamRuleType;
        }
        return null;
    }

    @JsonCreator
    public static StreamRuleType fromName(String name) {
        for (StreamRuleType streamRuleType : StreamRuleType.values()) {
            if (!streamRuleType.name().equals(name)) continue;
            return streamRuleType;
        }
        throw new IllegalArgumentException("Invalid Stream Rule Type specified: " + name);
    }

    public int getValue() {
        return this.value;
    }

    public String getShortDesc() {
        return this.shortDesc;
    }

    public String getLongDesc() {
        return this.longDesc;
    }
}

