/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.bson.types.ObjectId;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.alerts.AlertService;
import org.graylog2.auditlog.jersey.AuditLog;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Output;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRule;
import org.graylog2.rest.models.alarmcallbacks.requests.AlertReceivers;
import org.graylog2.rest.models.alarmcallbacks.requests.CreateAlarmCallbackRequest;
import org.graylog2.rest.models.streams.alerts.AlertConditionSummary;
import org.graylog2.rest.models.streams.requests.UpdateStreamRequest;
import org.graylog2.rest.models.system.outputs.responses.OutputSummary;
import org.graylog2.rest.resources.streams.requests.CloneStreamRequest;
import org.graylog2.rest.resources.streams.requests.CreateStreamRequest;
import org.graylog2.rest.resources.streams.responses.StreamListResponse;
import org.graylog2.rest.resources.streams.responses.StreamResponse;
import org.graylog2.rest.resources.streams.responses.TestMatchResponse;
import org.graylog2.rest.resources.streams.rules.requests.CreateStreamRuleRequest;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamRouterEngine;
import org.graylog2.streams.StreamRuleService;
import org.graylog2.streams.StreamService;
import org.graylog2.streams.events.StreamDeletedEvent;
import org.graylog2.streams.events.StreamsChangedEvent;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

@RequiresAuthentication
@Api(value="Streams", description="Manage streams")
@Path(value="/streams")
public class StreamResource
extends RestResource {
    private final StreamService streamService;
    private final StreamRuleService streamRuleService;
    private final StreamRouterEngine.Factory streamRouterEngineFactory;
    private final AlarmCallbackConfigurationService alarmCallbackConfigurationService;
    private final AlertService alertService;
    private final ClusterEventBus clusterEventBus;

    @Inject
    public StreamResource(StreamService streamService, StreamRuleService streamRuleService, StreamRouterEngine.Factory streamRouterEngineFactory, AlarmCallbackConfigurationService alarmCallbackConfigurationService, AlertService alertService, ClusterEventBus clusterEventBus) {
        this.streamService = streamService;
        this.streamRuleService = streamRuleService;
        this.streamRouterEngineFactory = streamRouterEngineFactory;
        this.alarmCallbackConfigurationService = alarmCallbackConfigurationService;
        this.alertService = alertService;
        this.clusterEventBus = clusterEventBus;
    }

    @POST
    @Timed
    @ApiOperation(value="Create a stream")
    @RequiresPermissions(value={"streams:create"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditLog(object="stream", captureRequestEntity=true, captureResponseEntity=true)
    public Response create(@ApiParam(name="JSON body", required=true) CreateStreamRequest cr) throws ValidationException {
        Stream stream = this.streamService.create(cr, this.getCurrentUser().getName());
        stream.setDisabled(true);
        String id = this.streamService.save(stream);
        List rules = (List)MoreObjects.firstNonNull(cr.rules(), Collections.emptyList());
        for (CreateStreamRuleRequest request : rules) {
            StreamRule streamRule = this.streamRuleService.create(id, request);
            this.streamRuleService.save(streamRule);
        }
        this.clusterEventBus.post(StreamsChangedEvent.create(stream.getId()));
        ImmutableMap result = ImmutableMap.of((Object)"stream_id", (Object)id);
        URI streamUri = this.getUriBuilderToSelf().path(StreamResource.class).path("{streamId}").build(new Object[]{id});
        return Response.created((URI)streamUri).entity((Object)result).build();
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all streams")
    @Produces(value={"application/json"})
    public StreamListResponse get() {
        List<Stream> allStreams = this.streamService.loadAll();
        ArrayList<Stream> streams = new ArrayList<Stream>(allStreams.size());
        for (Stream stream : allStreams) {
            if (!this.isPermitted("streams:read", stream.getId())) continue;
            streams.add(stream);
        }
        return StreamListResponse.create(streams.size(), streams.stream().map(this::streamToResponse).collect(Collectors.toSet()));
    }

    @GET
    @Path(value="/enabled")
    @Timed
    @ApiOperation(value="Get a list of all enabled streams")
    @Produces(value={"application/json"})
    public StreamListResponse getEnabled() throws NotFoundException {
        List<Stream> enabledStreams = this.streamService.loadAllEnabled();
        ArrayList<Stream> streams = new ArrayList<Stream>(enabledStreams.size());
        for (Stream stream : enabledStreams) {
            if (!this.isPermitted("streams:read", stream.getId())) continue;
            streams.add(stream);
        }
        return StreamListResponse.create(streams.size(), streams.stream().map(this::streamToResponse).collect(Collectors.toSet()));
    }

    @GET
    @Path(value="/{streamId}")
    @Timed
    @ApiOperation(value="Get a single stream")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public StreamResponse get(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") @NotEmpty String streamId) throws NotFoundException {
        this.checkPermission("streams:read", streamId);
        return this.streamToResponse(this.streamService.load(streamId));
    }

    @PUT
    @Timed
    @Path(value="/{streamId}")
    @ApiOperation(value="Update a stream")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditLog(object="stream", captureRequestEntity=true, captureResponseEntity=true)
    public StreamResponse update(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") String streamId, @ApiParam(name="JSON body", required=true) @Valid @NotNull UpdateStreamRequest cr) throws NotFoundException, ValidationException {
        this.checkPermission("streams:edit", streamId);
        Stream stream = this.streamService.load(streamId);
        if (!Strings.isNullOrEmpty((String)cr.title())) {
            stream.setTitle(cr.title());
        }
        if (!Strings.isNullOrEmpty((String)cr.description())) {
            stream.setDescription(cr.description());
        }
        if (cr.matchingType() != null) {
            try {
                stream.setMatchingType(Stream.MatchingType.valueOf(cr.matchingType()));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Invalid matching type '" + cr.matchingType() + "' specified. Should be one of: " + Arrays.toString((Object[])Stream.MatchingType.values()));
            }
        }
        this.streamService.save(stream);
        this.clusterEventBus.post(StreamsChangedEvent.create(stream.getId()));
        return this.streamToResponse(stream);
    }

    @DELETE
    @Path(value="/{streamId}")
    @Timed
    @ApiOperation(value="Delete a stream")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditLog(object="stream")
    public void delete(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") String streamId) throws NotFoundException {
        this.checkPermission("streams:edit", streamId);
        Stream stream = this.streamService.load(streamId);
        this.streamService.destroy(stream);
        this.clusterEventBus.post(StreamsChangedEvent.create(stream.getId()));
        this.clusterEventBus.post(StreamDeletedEvent.create(stream.getId()));
    }

    @POST
    @Path(value="/{streamId}/pause")
    @Timed
    @ApiOperation(value="Pause a stream")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid or missing Stream id.")})
    @AuditLog(action="stopped", object="stream")
    public void pause(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") @NotEmpty String streamId) throws NotFoundException, ValidationException {
        this.checkAnyPermission(new String[]{"streams:changestate", "streams:edit"}, streamId);
        Stream stream = this.streamService.load(streamId);
        this.streamService.pause(stream);
        this.clusterEventBus.post(StreamsChangedEvent.create(stream.getId()));
    }

    @POST
    @Path(value="/{streamId}/resume")
    @Timed
    @ApiOperation(value="Resume a stream")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid or missing Stream id.")})
    @AuditLog(action="started", object="stream")
    public void resume(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") @NotEmpty String streamId) throws NotFoundException, ValidationException {
        this.checkAnyPermission(new String[]{"streams:changestate", "streams:edit"}, streamId);
        Stream stream = this.streamService.load(streamId);
        this.streamService.resume(stream);
        this.clusterEventBus.post(StreamsChangedEvent.create(stream.getId()));
    }

    @POST
    @Path(value="/{streamId}/testMatch")
    @Timed
    @ApiOperation(value="Test matching of a stream against a supplied message")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid or missing Stream id.")})
    public TestMatchResponse testMatch(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") String streamId, @ApiParam(name="JSON body", required=true) @NotNull Map<String, Map<String, Object>> serialisedMessage) throws NotFoundException {
        this.checkPermission("streams:read", streamId);
        Stream stream = this.streamService.load(streamId);
        HashMap<String, Object> m = new HashMap<String, Object>(serialisedMessage.get("message"));
        String timeStamp = (String)MoreObjects.firstNonNull((Object)((String)m.get("timestamp")), (Object)DateTime.now((DateTimeZone)DateTimeZone.UTC).toString(ISODateTimeFormat.dateTime()));
        m.put("timestamp", Tools.dateTimeFromString(timeStamp));
        Message message = new Message(m);
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("stream-" + streamId + "-test-match-%d").build());
        StreamRouterEngine streamRouterEngine = this.streamRouterEngineFactory.create(Lists.newArrayList((Object[])new Stream[]{stream}), executor);
        List<StreamRouterEngine.StreamTestMatch> streamTestMatches = streamRouterEngine.testMatch(message);
        StreamRouterEngine.StreamTestMatch streamTestMatch = streamTestMatches.get(0);
        HashMap rules = Maps.newHashMap();
        for (Map.Entry<StreamRule, Boolean> match : streamTestMatch.getMatches().entrySet()) {
            rules.put(match.getKey().getId(), match.getValue());
        }
        return TestMatchResponse.create(streamTestMatch.isMatched(), rules);
    }

    @POST
    @Path(value="/{streamId}/clone")
    @Timed
    @ApiOperation(value="Clone a stream")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid or missing Stream id.")})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditLog(action="cloned", object="stream", captureRequestEntity=true, captureResponseEntity=true)
    public Response cloneStream(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") String streamId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CloneStreamRequest cr) throws ValidationException, NotFoundException {
        this.checkPermission("streams:create");
        this.checkPermission("streams:read", streamId);
        Stream sourceStream = this.streamService.load(streamId);
        HashMap streamData = Maps.newHashMap();
        streamData.put("title", cr.title());
        streamData.put("description", cr.description());
        streamData.put("creator_user_id", this.getCurrentUser().getName());
        streamData.put("created_at", Tools.nowUTC());
        streamData.put("matching_type", sourceStream.getMatchingType().toString());
        Stream stream = this.streamService.create(streamData);
        this.streamService.pause(stream);
        String id = this.streamService.save(stream);
        List<StreamRule> sourceStreamRules = this.streamRuleService.loadForStream(sourceStream);
        for (StreamRule streamRule : sourceStreamRules) {
            HashMap streamRuleData = Maps.newHashMapWithExpectedSize((int)6);
            streamRuleData.put("type", streamRule.getType().toInteger());
            streamRuleData.put("field", streamRule.getField());
            streamRuleData.put("value", streamRule.getValue());
            streamRuleData.put("inverted", streamRule.getInverted());
            streamRuleData.put("stream_id", new ObjectId(id));
            streamRuleData.put("description", streamRule.getDescription());
            StreamRule newStreamRule = this.streamRuleService.create(streamRuleData);
            this.streamRuleService.save(newStreamRule);
        }
        for (AlertCondition alertCondition : this.streamService.getAlertConditions(sourceStream)) {
            this.streamService.addAlertCondition(stream, alertCondition);
        }
        for (AlarmCallbackConfiguration alarmCallbackConfiguration : this.alarmCallbackConfigurationService.getForStream(sourceStream)) {
            CreateAlarmCallbackRequest request = new CreateAlarmCallbackRequest();
            request.type = alarmCallbackConfiguration.getType();
            request.configuration = alarmCallbackConfiguration.getConfiguration();
            AlarmCallbackConfiguration alarmCallback = this.alarmCallbackConfigurationService.create(stream.getId(), request, this.getCurrentUser().getName());
            this.alarmCallbackConfigurationService.save(alarmCallback);
        }
        for (Map.Entry entry : sourceStream.getAlertReceivers().entrySet()) {
            for (String receiver : (List)entry.getValue()) {
                this.streamService.addAlertReceiver(stream, (String)entry.getKey(), receiver);
            }
        }
        for (Output output : sourceStream.getOutputs()) {
            this.streamService.addOutput(stream, output);
        }
        this.clusterEventBus.post(StreamsChangedEvent.create(stream.getId()));
        ImmutableMap result = ImmutableMap.of((Object)"stream_id", (Object)id);
        URI uRI = this.getUriBuilderToSelf().path(StreamResource.class).path("{streamId}").build(new Object[]{id});
        return Response.created((URI)uRI).entity((Object)result).build();
    }

    private StreamResponse streamToResponse(Stream stream) {
        List<String> emailAlertReceivers = stream.getAlertReceivers().get("emails");
        List<String> usersAlertReceivers = stream.getAlertReceivers().get("users");
        Collection alertConditions = this.streamService.getAlertConditions(stream).stream().map(alertCondition -> AlertConditionSummary.create(alertCondition.getId(), alertCondition.getTypeString(), alertCondition.getCreatorUserId(), alertCondition.getCreatedAt().toDate(), alertCondition.getParameters(), this.alertService.inGracePeriod((AlertCondition)alertCondition), alertCondition.getTitle())).collect(Collectors.toList());
        return StreamResponse.create(stream.getId(), (String)stream.getFields().get("creator_user_id"), this.outputsToSummaries(stream.getOutputs()), stream.getMatchingType().name(), stream.getDescription(), stream.getFields().get("created_at").toString(), stream.getDisabled(), stream.getStreamRules(), alertConditions, AlertReceivers.create(emailAlertReceivers == null ? Collections.emptyList() : emailAlertReceivers, usersAlertReceivers == null ? Collections.emptyList() : usersAlertReceivers), stream.getTitle(), stream.getContentPack());
    }

    private Collection<OutputSummary> outputsToSummaries(Collection<Output> outputs) {
        return outputs.stream().map(output -> OutputSummary.create(output.getId(), output.getTitle(), output.getType(), output.getCreatorUserId(), new DateTime((Object)output.getCreatedAt()), output.getConfiguration(), output.getContentPack())).collect(Collectors.toSet());
    }
}

