/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.eis.CachingSessionDAO;
import org.graylog2.security.MongoDBSessionService;
import org.graylog2.security.MongoDbSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbSessionDAO
extends CachingSessionDAO {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbSessionDAO.class);
    private final MongoDBSessionService mongoDBSessionService;

    @Inject
    public MongoDbSessionDAO(MongoDBSessionService mongoDBSessionService) {
        this.mongoDBSessionService = mongoDBSessionService;
    }

    protected Serializable doCreate(Session session) {
        Serializable id = this.generateSessionId(session);
        this.assignSessionId(session, id);
        HashMap fields = Maps.newHashMap();
        fields.put("session_id", id);
        fields.put("host", session.getHost());
        fields.put("start_timestamp", session.getStartTimestamp());
        fields.put("last_access_time", session.getLastAccessTime());
        fields.put("timeout", session.getTimeout());
        HashMap attributes = Maps.newHashMap();
        for (Object key : session.getAttributeKeys()) {
            attributes.put(key.toString(), session.getAttribute(key));
        }
        fields.put("attributes", attributes);
        MongoDbSession dbSession = new MongoDbSession(fields);
        LOG.debug("Created session {}", (Object)id);
        String objectId = this.mongoDBSessionService.saveWithoutValidation(dbSession);
        return id;
    }

    protected Session doReadSession(Serializable sessionId) {
        MongoDbSession dbSession = this.mongoDBSessionService.load(sessionId.toString());
        LOG.debug("Reading session for id {} from MongoDB: {}", (Object)sessionId, (Object)dbSession);
        if (dbSession == null) {
            return null;
        }
        return this.getSimpleSession(sessionId, dbSession);
    }

    private SimpleSession getSimpleSession(Serializable sessionId, MongoDbSession dbSession) {
        SimpleSession session = new SimpleSession();
        this.assignSessionId((Session)session, sessionId);
        session.setHost(dbSession.getHost());
        session.setTimeout(dbSession.getTimeout());
        session.setStartTimestamp(dbSession.getStartTimestamp());
        session.setLastAccessTime(dbSession.getLastAccessTime());
        session.setExpired(dbSession.isExpired());
        session.setAttributes(dbSession.getAttributes());
        return session;
    }

    protected void doUpdate(Session session) {
        MongoDbSession dbSession = this.mongoDBSessionService.load(session.getId().toString());
        if (null == dbSession) {
            throw new RuntimeException("Couldn't load session <" + session.getId() + ">");
        }
        LOG.debug("Updating session {}", (Object)session);
        dbSession.setHost(session.getHost());
        dbSession.setTimeout(session.getTimeout());
        dbSession.setStartTimestamp(session.getStartTimestamp());
        dbSession.setLastAccessTime(session.getLastAccessTime());
        if (!(session instanceof SimpleSession)) {
            throw new RuntimeException("Unsupported session type: " + session.getClass().getCanonicalName());
        }
        SimpleSession simpleSession = (SimpleSession)session;
        dbSession.setAttributes(simpleSession.getAttributes());
        dbSession.setExpired(simpleSession.isExpired());
        this.mongoDBSessionService.saveWithoutValidation(dbSession);
    }

    protected void doDelete(Session session) {
        LOG.debug("Deleting session {}", (Object)session);
        Serializable id = session.getId();
        MongoDbSession dbSession = this.mongoDBSessionService.load(id.toString());
        this.mongoDBSessionService.destroy(dbSession);
    }

    public Collection<Session> getActiveSessions() {
        LOG.debug("Retrieving all active sessions.");
        Collection<MongoDbSession> dbSessions = this.mongoDBSessionService.loadAll();
        ArrayList sessions = Lists.newArrayList();
        for (MongoDbSession dbSession : dbSessions) {
            sessions.add(this.getSimpleSession((Serializable)((Object)dbSession.getSessionId()), dbSession));
        }
        return sessions;
    }
}

