/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import javax.inject.Inject;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.SimpleCredentialsMatcher;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.PasswordAlgorithmFactory;
import org.graylog2.security.realm.UserAccount;

public class PasswordAlgorithmCredentialsMatcher
extends SimpleCredentialsMatcher {
    private final PasswordAlgorithmFactory passwordAlgorithmFactory;

    @Inject
    public PasswordAlgorithmCredentialsMatcher(PasswordAlgorithmFactory passwordAlgorithmFactory) {
        this.passwordAlgorithmFactory = passwordAlgorithmFactory;
    }

    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        if (token instanceof UsernamePasswordToken && info instanceof UserAccount) {
            UsernamePasswordToken usernamePasswordToken = (UsernamePasswordToken)token;
            UserAccount userAccount = (UserAccount)info;
            User user = userAccount.getUser();
            return user.isUserPassword(String.valueOf(usernamePasswordToken.getPassword()));
        }
        return false;
    }
}

