/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.buffers;

import com.eaio.uuid.UUID;
import com.google.common.base.MoreObjects;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventTranslatorOneArg;
import java.nio.ByteBuffer;
import org.graylog2.plugin.journal.RawMessage;

public class RawMessageEvent {
    private RawMessage rawMessage;
    private byte[] messageIdBytes;
    private byte[] encodedRawMessage;
    public static final EventFactory<RawMessageEvent> FACTORY = new EventFactory<RawMessageEvent>(){

        public RawMessageEvent newInstance() {
            return new RawMessageEvent();
        }
    };
    public static final EventTranslatorOneArg<RawMessageEvent, RawMessage> TRANSLATOR = new EventTranslatorOneArg<RawMessageEvent, RawMessage>(){

        public void translateTo(RawMessageEvent event, long sequence, RawMessage arg0) {
            event.setRawMessage(arg0);
        }
    };

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("raw", (Object)this.getRawMessage()).add("uuid", (Object)this.getMessageId()).add("encodedLength", this.getEncodedRawMessage().length).toString();
    }

    public RawMessage getRawMessage() {
        return this.rawMessage;
    }

    public void setRawMessage(RawMessage rawMessage) {
        this.rawMessage = rawMessage;
    }

    public byte[] getEncodedRawMessage() {
        return this.encodedRawMessage;
    }

    public void setEncodedRawMessage(byte[] encodedRawMessage) {
        this.encodedRawMessage = encodedRawMessage;
    }

    public void setMessageIdBytes(byte[] messageIdBytes) {
        this.messageIdBytes = messageIdBytes;
    }

    public byte[] getMessageIdBytes() {
        return this.messageIdBytes;
    }

    public UUID getMessageId() {
        ByteBuffer wrap = ByteBuffer.wrap(this.messageIdBytes);
        return new UUID(wrap.asLongBuffer().get(0), wrap.asLongBuffer().get(1));
    }
}

