/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public abstract class ProxiedResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ProxiedResource.class);
    protected final String authenticationToken;
    protected final NodeService nodeService;
    protected final RemoteInterfaceProvider remoteInterfaceProvider;

    protected ProxiedResource(@Context HttpHeaders httpHeaders, NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider) {
        this.nodeService = nodeService;
        this.remoteInterfaceProvider = remoteInterfaceProvider;
        List authenticationTokens = httpHeaders.getRequestHeader("Authorization");
        this.authenticationToken = authenticationTokens != null && authenticationTokens.size() >= 1 ? (String)authenticationTokens.get(0) : null;
    }

    protected <RemoteInterfaceType, RemoteCallResponseType> Map<String, Optional<RemoteCallResponseType>> getForAllNodes(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> fn, Function<String, Optional<RemoteInterfaceType>> interfaceProvider) {
        return this.getForAllNodes(fn, interfaceProvider, Function.identity());
    }

    protected <RemoteInterfaceType, FinalResponseType, RemoteCallResponseType> Map<String, Optional<FinalResponseType>> getForAllNodes(Function<RemoteInterfaceType, Call<RemoteCallResponseType>> fn, Function<String, Optional<RemoteInterfaceType>> interfaceProvider, Function<RemoteCallResponseType, FinalResponseType> transformer) {
        return this.nodeService.allActive().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Optional remoteInterface = (Optional)interfaceProvider.apply((String)entry.getKey());
            if (!remoteInterface.isPresent()) {
                return Optional.empty();
            }
            Call call = (Call)fn.apply(remoteInterface.get());
            try {
                Response response = call.execute();
                if (response.isSuccessful()) {
                    return Optional.of(transformer.apply(response.body()));
                }
                LOG.warn("Unable to call " + call.request().url().toString() + " on node <" + (String)entry.getKey() + ">, result: " + response.message());
                return Optional.empty();
            }
            catch (IOException e) {
                LOG.warn("Unable to call " + call.request().url().toString() + " on node <" + (String)entry.getKey() + ">, caught exception: {} ({})", (Object)e.getMessage(), e.getClass());
                return Optional.empty();
            }
        }));
    }

    protected <RemoteInterfaceType> Function<String, Optional<RemoteInterfaceType>> createRemoteInterfaceProvider(Class<RemoteInterfaceType> interfaceClass) {
        return nodeId -> {
            try {
                Node targetNode = this.nodeService.byNodeId((String)nodeId);
                return Optional.of(this.remoteInterfaceProvider.get(targetNode, this.authenticationToken, interfaceClass));
            }
            catch (NodeNotFoundException e) {
                LOG.warn("Node <" + nodeId + "> not found while trying to call " + interfaceClass.getName() + " on it.");
                return Optional.empty();
            }
        };
    }
}

