/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import org.graylog2.plugin.streams.StreamRuleType;
import org.graylog2.streams.InvalidStreamRuleTypeException;
import org.graylog2.streams.matchers.ExactMatcher;
import org.graylog2.streams.matchers.FieldPresenceMatcher;
import org.graylog2.streams.matchers.GreaterMatcher;
import org.graylog2.streams.matchers.RegexMatcher;
import org.graylog2.streams.matchers.SmallerMatcher;
import org.graylog2.streams.matchers.StreamRuleMatcher;

public class StreamRuleMatcherFactory {
    public static StreamRuleMatcher build(StreamRuleType ruleType) throws InvalidStreamRuleTypeException {
        StreamRuleMatcher matcher = null;
        switch (ruleType) {
            case EXACT: {
                matcher = new ExactMatcher();
                break;
            }
            case REGEX: {
                matcher = new RegexMatcher();
                break;
            }
            case GREATER: {
                matcher = new GreaterMatcher();
                break;
            }
            case SMALLER: {
                matcher = new SmallerMatcher();
                break;
            }
            case PRESENCE: {
                matcher = new FieldPresenceMatcher();
                break;
            }
            default: {
                throw new InvalidStreamRuleTypeException();
            }
        }
        return matcher;
    }
}

