/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRule;
import org.graylog2.rest.resources.streams.rules.requests.CreateStreamRuleRequest;
import org.graylog2.streams.StreamImpl;
import org.graylog2.streams.StreamRuleImpl;
import org.graylog2.streams.StreamRuleService;

public class StreamRuleServiceImpl
extends PersistedServiceImpl
implements StreamRuleService {
    @Inject
    public StreamRuleServiceImpl(MongoConnection mongoConnection) {
        super(mongoConnection);
    }

    @Override
    public StreamRule load(String id) throws NotFoundException {
        BasicDBObject o = (BasicDBObject)this.get(StreamRuleImpl.class, new ObjectId(id));
        if (o == null) {
            throw new NotFoundException("Couldn't find stream rule with ID" + id);
        }
        return new StreamRuleImpl((ObjectId)o.get("_id"), o.toMap());
    }

    @Override
    public List<StreamRule> loadForStream(Stream stream) throws NotFoundException {
        return this.loadForStreamId(stream.getId());
    }

    @Override
    public StreamRule create(Map<String, Object> data) {
        return new StreamRuleImpl(data);
    }

    @Override
    public StreamRule create(String streamid, CreateStreamRuleRequest cr) {
        HashMap streamRuleData = Maps.newHashMap();
        streamRuleData.put("type", cr.type());
        streamRuleData.put("value", cr.value());
        streamRuleData.put("field", cr.field());
        streamRuleData.put("inverted", cr.inverted());
        streamRuleData.put("stream_id", new ObjectId(streamid));
        streamRuleData.put("description", cr.description());
        return new StreamRuleImpl(streamRuleData);
    }

    @Override
    public List<StreamRule> loadForStreamId(String streamId) throws NotFoundException {
        ObjectId id = new ObjectId(streamId);
        ArrayList<StreamRule> streamRules = new ArrayList<StreamRule>();
        List<DBObject> respStreamRules = this.query(StreamRuleImpl.class, (DBObject)new BasicDBObject("stream_id", (Object)id));
        for (DBObject streamRule : respStreamRules) {
            streamRules.add(this.load(streamRule.get("_id").toString()));
        }
        return streamRules;
    }

    @Override
    public long totalStreamRuleCount() {
        return this.totalCount(StreamRuleImpl.class);
    }

    @Override
    public long streamRuleCount(String streamId) {
        return this.streamRuleCount(new ObjectId(streamId));
    }

    private long streamRuleCount(ObjectId streamId) {
        return this.count(StreamRuleImpl.class, (DBObject)new BasicDBObject("stream_id", (Object)streamId));
    }

    @Override
    public Map<String, Long> streamRuleCountByStream() {
        DBCursor streamIds = this.collection(StreamImpl.class).find((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("_id", (Object)1));
        HashMap<String, Long> streamRules = new HashMap<String, Long>(streamIds.size());
        for (DBObject keys : streamIds) {
            ObjectId streamId = (ObjectId)keys.get("_id");
            streamRules.put(streamId.toHexString(), this.streamRuleCount(streamId));
        }
        return streamRules;
    }
}

