/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.shutdown;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.Configuration;
import org.graylog2.initializers.BufferSynchronizerService;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.shared.initializers.InputSetupService;
import org.graylog2.shared.initializers.JerseyService;
import org.graylog2.shared.initializers.PeriodicalsService;
import org.graylog2.shared.journal.JournalReader;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GracefulShutdown
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulShutdown.class);
    private static final int SLEEP_SECS = 1;
    private final Configuration configuration;
    private final BufferSynchronizerService bufferSynchronizerService;
    private final PeriodicalsService periodicalsService;
    private final InputSetupService inputSetupService;
    private final ServerStatus serverStatus;
    private final ActivityWriter activityWriter;
    private final JerseyService jerseyService;
    private final JournalReader journalReader;

    @Inject
    public GracefulShutdown(ServerStatus serverStatus, ActivityWriter activityWriter, Configuration configuration, BufferSynchronizerService bufferSynchronizerService, PeriodicalsService periodicalsService, InputSetupService inputSetupService, JerseyService jerseyService, JournalReader journalReader) {
        this.serverStatus = serverStatus;
        this.activityWriter = activityWriter;
        this.configuration = configuration;
        this.bufferSynchronizerService = bufferSynchronizerService;
        this.periodicalsService = periodicalsService;
        this.inputSetupService = inputSetupService;
        this.jerseyService = jerseyService;
        this.journalReader = journalReader;
    }

    @Override
    public void run() {
        this.doRun(true);
    }

    public void runWithoutExit() {
        this.doRun(false);
    }

    private void doRun(boolean exit) {
        LOG.info("Graceful shutdown initiated.");
        this.serverStatus.shutdown();
        LOG.info("Node status: [{}]. Waiting <{}sec> for possible load balancers to recognize state change.", (Object)this.serverStatus.getLifecycle(), (Object)this.configuration.getLoadBalancerRecognitionPeriodSeconds());
        Uninterruptibles.sleepUninterruptibly((long)this.configuration.getLoadBalancerRecognitionPeriodSeconds(), (TimeUnit)TimeUnit.SECONDS);
        this.activityWriter.write(new Activity("Graceful shutdown initiated.", GracefulShutdown.class));
        Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.jerseyService.stopAsync();
        this.inputSetupService.stopAsync();
        this.jerseyService.awaitTerminated();
        this.inputSetupService.awaitTerminated();
        this.journalReader.stopAsync().awaitTerminated();
        this.bufferSynchronizerService.stopAsync().awaitTerminated();
        this.periodicalsService.stopAsync().awaitTerminated();
        LOG.info("Goodbye.");
        if (exit) {
            System.exit(0);
        }
    }
}

