/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bundles;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.ConfigurationException;
import org.graylog2.bundles.ConfigurationBundle;
import org.graylog2.bundles.Converter;
import org.graylog2.bundles.Dashboard;
import org.graylog2.bundles.DashboardWidget;
import org.graylog2.bundles.Extractor;
import org.graylog2.bundles.GrokPattern;
import org.graylog2.bundles.Input;
import org.graylog2.bundles.Output;
import org.graylog2.bundles.Stream;
import org.graylog2.bundles.StreamRule;
import org.graylog2.dashboards.DashboardImpl;
import org.graylog2.dashboards.DashboardService;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.DashboardWidgetCreator;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.database.NotFoundException;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.inputs.InputService;
import org.graylog2.inputs.converters.ConverterFactory;
import org.graylog2.inputs.extractors.ExtractorFactory;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.rest.models.dashboards.requests.WidgetPositionsRequest;
import org.graylog2.shared.inputs.InputLauncher;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.graylog2.streams.OutputImpl;
import org.graylog2.streams.OutputService;
import org.graylog2.streams.StreamRuleImpl;
import org.graylog2.streams.StreamRuleService;
import org.graylog2.streams.StreamService;
import org.graylog2.timeranges.TimeRangeFactory;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleImporter {
    private static final Logger LOG = LoggerFactory.getLogger(BundleImporter.class);
    private final InputService inputService;
    private final InputRegistry inputRegistry;
    private final ExtractorFactory extractorFactory;
    private final StreamService streamService;
    private final StreamRuleService streamRuleService;
    private final OutputService outputService;
    private final DashboardService dashboardService;
    private final DashboardWidgetCreator dashboardWidgetCreator;
    private final ServerStatus serverStatus;
    private final Searches searches;
    private final MessageInputFactory messageInputFactory;
    private final InputLauncher inputLauncher;
    private final GrokPatternService grokPatternService;
    private final TimeRangeFactory timeRangeFactory;
    private final Map<String, org.graylog2.grok.GrokPattern> createdGrokPatterns = new HashMap<String, org.graylog2.grok.GrokPattern>();
    private final Map<String, MessageInput> createdInputs = new HashMap<String, MessageInput>();
    private final Map<String, org.graylog2.plugin.streams.Output> createdOutputs = new HashMap<String, org.graylog2.plugin.streams.Output>();
    private final Map<String, org.graylog2.plugin.streams.Stream> createdStreams = new HashMap<String, org.graylog2.plugin.streams.Stream>();
    private final Map<String, org.graylog2.dashboards.Dashboard> createdDashboards = new HashMap<String, org.graylog2.dashboards.Dashboard>();
    private final Map<String, org.graylog2.plugin.streams.Output> outputsByReferenceId = new HashMap<String, org.graylog2.plugin.streams.Output>();
    private final Map<String, org.graylog2.plugin.streams.Stream> streamsByReferenceId = new HashMap<String, org.graylog2.plugin.streams.Stream>();

    @Inject
    public BundleImporter(InputService inputService, InputRegistry inputRegistry, ExtractorFactory extractorFactory, StreamService streamService, StreamRuleService streamRuleService, OutputService outputService, DashboardService dashboardService, DashboardWidgetCreator dashboardWidgetCreator, ServerStatus serverStatus, Searches searches, MessageInputFactory messageInputFactory, InputLauncher inputLauncher, GrokPatternService grokPatternService, TimeRangeFactory timeRangeFactory) {
        this.inputService = inputService;
        this.inputRegistry = inputRegistry;
        this.extractorFactory = extractorFactory;
        this.streamService = streamService;
        this.streamRuleService = streamRuleService;
        this.outputService = outputService;
        this.dashboardService = dashboardService;
        this.dashboardWidgetCreator = dashboardWidgetCreator;
        this.serverStatus = serverStatus;
        this.searches = searches;
        this.messageInputFactory = messageInputFactory;
        this.inputLauncher = inputLauncher;
        this.grokPatternService = grokPatternService;
        this.timeRangeFactory = timeRangeFactory;
    }

    public void runImport(ConfigurationBundle bundle, String userName) {
        String bundleId = bundle.getId();
        try {
            this.createGrokPatterns(bundleId, bundle.getGrokPatterns());
            this.createInputs(bundleId, bundle.getInputs(), userName);
            this.createOutputs(bundleId, bundle.getOutputs(), userName);
            this.createStreams(bundleId, bundle.getStreams(), userName);
            this.createDashboards(bundleId, bundle.getDashboards(), userName);
        }
        catch (Exception e) {
            LOG.error("Error while creating entities in content pack. Starting rollback.", (Throwable)e);
            if (!this.rollback()) {
                LOG.error("Rollback unsuccessful.");
            }
            Throwables.propagate((Throwable)e);
        }
    }

    private boolean rollback() {
        boolean success = true;
        try {
            this.deleteCreatedDashboards();
        }
        catch (Exception e) {
            LOG.error("Error while removing dashboards during rollback.", (Throwable)e);
            success = false;
        }
        try {
            this.deleteCreatedStreams();
        }
        catch (Exception e) {
            LOG.error("Error while removing streams during rollback.", (Throwable)e);
            success = false;
        }
        try {
            this.deleteCreatedOutputs();
        }
        catch (Exception e) {
            LOG.error("Error while removing outputs during rollback.", (Throwable)e);
            success = false;
        }
        try {
            this.deleteCreatedGrokPatterns();
        }
        catch (Exception e) {
            LOG.error("Error while removing grok patterns during rollback.", (Throwable)e);
            success = false;
        }
        try {
            this.deleteCreatedInputs();
        }
        catch (Exception e) {
            LOG.error("Error while removing inputs during rollback.", (Throwable)e);
            success = false;
        }
        return success;
    }

    private void deleteCreatedGrokPatterns() throws NotFoundException {
        for (String grokPatternName : this.createdGrokPatterns.keySet()) {
            org.graylog2.grok.GrokPattern grokPattern = this.grokPatternService.load(grokPatternName);
            if (grokPattern.id != null) {
                LOG.debug("Deleting grok pattern \"{}\" from database", (Object)grokPatternName);
                this.grokPatternService.delete(grokPattern.id.toHexString());
                continue;
            }
            LOG.debug("Couldn't find grok pattern \"{}\" in database", (Object)grokPatternName);
        }
    }

    private void deleteCreatedInputs() throws NotFoundException {
        for (Map.Entry<String, MessageInput> entry : this.createdInputs.entrySet()) {
            String inputId = entry.getKey();
            MessageInput messageInput = entry.getValue();
            LOG.debug("Terminating message input {}", (Object)inputId);
            this.inputRegistry.remove(messageInput);
            org.graylog2.inputs.Input input = this.inputService.find(messageInput.getId());
            this.inputService.destroy(input);
        }
    }

    private void deleteCreatedOutputs() throws NotFoundException {
        for (Map.Entry<String, org.graylog2.plugin.streams.Output> entry : this.createdOutputs.entrySet()) {
            LOG.debug("Deleting output {} from database", (Object)entry.getKey());
            this.outputService.destroy(entry.getValue());
        }
    }

    private void deleteCreatedStreams() throws NotFoundException {
        for (Map.Entry<String, org.graylog2.plugin.streams.Stream> entry : this.createdStreams.entrySet()) {
            LOG.debug("Deleting stream {} from database", (Object)entry.getKey());
            this.streamService.destroy(entry.getValue());
        }
    }

    private void deleteCreatedDashboards() {
        for (Map.Entry<String, org.graylog2.dashboards.Dashboard> entry : this.createdDashboards.entrySet()) {
            String dashboardId = entry.getKey();
            LOG.debug("Deleting dashboard {} from database", (Object)dashboardId);
            this.dashboardService.destroy(entry.getValue());
        }
    }

    private void createGrokPatterns(String bundleId, Set<GrokPattern> grokPatterns) throws ValidationException {
        for (GrokPattern grokPattern : grokPatterns) {
            org.graylog2.grok.GrokPattern createdGrokPattern = this.createGrokPattern(bundleId, grokPattern);
            this.createdGrokPatterns.put(grokPattern.name(), createdGrokPattern);
        }
    }

    private org.graylog2.grok.GrokPattern createGrokPattern(String bundleId, GrokPattern grokPattern) throws ValidationException {
        org.graylog2.grok.GrokPattern pattern = new org.graylog2.grok.GrokPattern();
        pattern.name = grokPattern.name();
        pattern.pattern = grokPattern.pattern();
        pattern.contentPack = bundleId;
        return this.grokPatternService.save(pattern);
    }

    private void createInputs(String bundleId, Set<Input> inputs, String userName) throws Extractor.ReservedFieldException, ConfigurationException, NoSuchInputTypeException, ValidationException, ExtractorFactory.NoSuchExtractorException, NotFoundException, org.graylog2.plugin.configuration.ConfigurationException {
        for (Input input : inputs) {
            MessageInput messageInput = this.createMessageInput(bundleId, input, userName);
            this.createdInputs.put(messageInput.getId(), messageInput);
            this.inputLauncher.launch(messageInput);
        }
    }

    private MessageInput createMessageInput(String bundleId, Input inputDescription, String userName) throws NoSuchInputTypeException, org.graylog2.plugin.configuration.ConfigurationException, ValidationException, NotFoundException, ConfigurationException, ExtractorFactory.NoSuchExtractorException, Extractor.ReservedFieldException {
        Configuration inputConfig = new Configuration(inputDescription.getConfiguration());
        DateTime createdAt = Tools.nowUTC();
        MessageInput messageInput = this.messageInputFactory.create(inputDescription.getType(), inputConfig);
        messageInput.setTitle(inputDescription.getTitle());
        messageInput.setGlobal(inputDescription.isGlobal());
        messageInput.setCreatorUserId(userName);
        messageInput.setCreatedAt(createdAt);
        messageInput.setContentPack(bundleId);
        messageInput.checkConfiguration();
        if (messageInput.isExclusive() && this.inputRegistry.hasTypeRunning(messageInput.getClass())) {
            String error = "Type is exclusive and already has input running.";
            LOG.error("Type is exclusive and already has input running.");
        }
        org.graylog2.inputs.Input mongoInput = this.inputService.create(this.buildMongoDbInput(inputDescription, userName, createdAt, bundleId));
        String persistId = this.inputService.save(mongoInput);
        messageInput.setPersistId(persistId);
        messageInput.initialize();
        this.addStaticFields(messageInput, inputDescription.getStaticFields());
        this.addExtractors(messageInput, inputDescription.getExtractors(), userName);
        return messageInput;
    }

    private void validateExtractor(Extractor extractorDescription) throws ValidationException {
        if (extractorDescription.getSourceField().isEmpty()) {
            throw new ValidationException("Missing parameter source_field in extractor " + extractorDescription.getTitle());
        }
        if (extractorDescription.getType() != Extractor.Type.GROK && extractorDescription.getType() != Extractor.Type.JSON && extractorDescription.getTargetField().isEmpty()) {
            throw new ValidationException("Missing parameter target_field in extractor " + extractorDescription.getTitle());
        }
    }

    private void addExtractors(MessageInput messageInput, List<Extractor> extractors, String userName) throws Extractor.ReservedFieldException, ConfigurationException, ExtractorFactory.NoSuchExtractorException, NotFoundException, ValidationException {
        for (Extractor extractor : extractors) {
            this.addExtractor(messageInput, extractor, userName);
        }
    }

    private void addExtractor(MessageInput messageInput, Extractor extractorDescription, String userName) throws NotFoundException, ValidationException, ConfigurationException, ExtractorFactory.NoSuchExtractorException, Extractor.ReservedFieldException {
        this.validateExtractor(extractorDescription);
        String extractorId = UUID.randomUUID().toString();
        org.graylog2.plugin.inputs.Extractor extractor = this.extractorFactory.factory(extractorId, extractorDescription.getTitle(), extractorDescription.getOrder(), extractorDescription.getCursorStrategy(), extractorDescription.getType(), extractorDescription.getSourceField(), extractorDescription.getTargetField(), extractorDescription.getConfiguration(), userName, this.createConverters(extractorDescription.getConverters()), extractorDescription.getConditionType(), extractorDescription.getConditionValue());
        org.graylog2.inputs.Input mongoInput = this.inputService.find(messageInput.getPersistId());
        this.inputService.addExtractor(mongoInput, extractor);
    }

    private List<org.graylog2.plugin.inputs.Converter> createConverters(List<Converter> requestedConverters) {
        ImmutableList.Builder converters = ImmutableList.builder();
        for (Converter converter : requestedConverters) {
            try {
                converters.add((Object)ConverterFactory.factory(converter.getType(), converter.getConfiguration()));
            }
            catch (ConverterFactory.NoSuchConverterException e) {
                LOG.warn("No such converter [" + (Object)((Object)converter.getType()) + "]. Skipping.", (Throwable)e);
            }
            catch (ConfigurationException e) {
                LOG.warn("Missing configuration for [" + (Object)((Object)converter.getType()) + "]. Skipping.", (Throwable)e);
            }
        }
        return converters.build();
    }

    private void addStaticFields(MessageInput messageInput, Map<String, String> staticFields) throws NotFoundException, ValidationException {
        for (Map.Entry<String, String> staticField : staticFields.entrySet()) {
            this.addStaticField(messageInput, staticField.getKey(), staticField.getValue());
        }
    }

    private void addStaticField(MessageInput messageInput, String key, String value) throws ValidationException, NotFoundException {
        if (!Message.validKey(key)) {
            String errorMessage = "Invalid key: [" + key + "]";
            LOG.error(errorMessage);
            throw new ValidationException(errorMessage);
        }
        if (Strings.isNullOrEmpty((String)key) || Strings.isNullOrEmpty((String)value)) {
            String errorMessage = "Missing attributes: key=[" + key + "], value=[" + value + "]";
            LOG.error(errorMessage);
            throw new ValidationException(errorMessage);
        }
        if (Message.RESERVED_FIELDS.contains((Object)key) && !Message.RESERVED_SETTABLE_FIELDS.contains((Object)key)) {
            String errorMessage = "Cannot add static field. Field [" + key + "] is reserved.";
            LOG.error(errorMessage);
            throw new ValidationException(errorMessage);
        }
        messageInput.addStaticField(key, value);
        org.graylog2.inputs.Input mongoInput = this.inputService.find(messageInput.getPersistId());
        this.inputService.addStaticField(mongoInput, key, value);
    }

    private Map<String, Object> buildMongoDbInput(Input input, String userName, DateTime createdAt, String bundleId) {
        ImmutableMap.Builder inputData = ImmutableMap.builder();
        inputData.put((Object)"title", (Object)input.getTitle());
        inputData.put((Object)"type", (Object)input.getType());
        inputData.put((Object)"creator_user_id", (Object)userName);
        inputData.put((Object)"configuration", input.getConfiguration());
        inputData.put((Object)"created_at", (Object)createdAt);
        inputData.put((Object)"content_pack", (Object)bundleId);
        if (input.isGlobal()) {
            inputData.put((Object)"global", (Object)true);
        } else {
            inputData.put((Object)"node_id", (Object)this.serverStatus.getNodeId().toString());
        }
        return inputData.build();
    }

    private void createOutputs(String bundleId, Set<Output> outputs, String userName) throws ValidationException {
        for (Output outputDescription : outputs) {
            org.graylog2.plugin.streams.Output output = this.createOutput(bundleId, outputDescription, userName);
            this.createdOutputs.put(output.getId(), output);
        }
    }

    private org.graylog2.plugin.streams.Output createOutput(String bundleId, Output outputDescription, String userName) throws ValidationException {
        String referenceId = outputDescription.getId();
        org.graylog2.plugin.streams.Output output = this.outputService.create(OutputImpl.create(outputDescription.getId(), outputDescription.getTitle(), outputDescription.getType(), userName, outputDescription.getConfiguration(), Tools.nowUTC().toDate(), bundleId));
        if (!Strings.isNullOrEmpty((String)referenceId)) {
            this.outputsByReferenceId.put(referenceId, output);
        }
        return output;
    }

    private void createStreams(String bundleId, Set<Stream> streams, String userName) throws ValidationException {
        for (Stream streamDescription : streams) {
            String referenceId = streamDescription.getId();
            org.graylog2.plugin.streams.Stream stream = this.createStream(bundleId, streamDescription, userName);
            this.createdStreams.put(stream.getId(), stream);
            if (Strings.isNullOrEmpty((String)referenceId)) continue;
            this.streamsByReferenceId.put(referenceId, stream);
        }
    }

    private org.graylog2.plugin.streams.Stream createStream(String bundleId, Stream streamDescription, String userName) throws ValidationException {
        ImmutableMap.Builder streamData = ImmutableMap.builder();
        streamData.put((Object)"title", (Object)streamDescription.getTitle());
        streamData.put((Object)"description", (Object)streamDescription.getDescription());
        streamData.put((Object)"disabled", (Object)streamDescription.isDisabled());
        streamData.put((Object)"matching_type", (Object)streamDescription.getMatchingType().name());
        streamData.put((Object)"creator_user_id", (Object)userName);
        streamData.put((Object)"created_at", (Object)Tools.nowUTC());
        streamData.put((Object)"content_pack", (Object)bundleId);
        org.graylog2.plugin.streams.Stream stream = this.streamService.create((Map<String, Object>)streamData.build());
        String streamId = this.streamService.save(stream);
        if (streamDescription.getStreamRules() != null) {
            for (StreamRule streamRule : streamDescription.getStreamRules()) {
                ImmutableMap.Builder streamRuleData = ImmutableMap.builder();
                streamRuleData.put((Object)"type", (Object)streamRule.getType().toInteger());
                streamRuleData.put((Object)"value", (Object)streamRule.getValue());
                streamRuleData.put((Object)"field", (Object)streamRule.getField());
                streamRuleData.put((Object)"inverted", (Object)streamRule.isInverted());
                streamRuleData.put((Object)"stream_id", (Object)new ObjectId(streamId));
                streamRuleData.put((Object)"content_pack", (Object)bundleId);
                streamRuleData.put((Object)"description", (Object)streamRule.getDescription());
                this.streamRuleService.save(new StreamRuleImpl((Map<String, Object>)streamRuleData.build()));
            }
        }
        for (String outputId : streamDescription.getOutputs()) {
            if (Strings.isNullOrEmpty((String)outputId)) {
                LOG.warn("Couldn't find referenced output <{}> for stream <{}>", (Object)outputId, (Object)streamDescription.getTitle());
                continue;
            }
            this.streamService.addOutput(stream, this.outputsByReferenceId.get(outputId));
        }
        return stream;
    }

    private void createDashboards(String bundleId, Set<Dashboard> dashboards, String userName) throws DashboardWidget.NoSuchWidgetTypeException, InvalidWidgetConfigurationException, InvalidRangeParametersException, ValidationException {
        for (Dashboard dashboard : dashboards) {
            org.graylog2.dashboards.Dashboard createdDashboard = this.createDashboard(bundleId, dashboard, userName);
            this.createdDashboards.put(createdDashboard.getId(), createdDashboard);
        }
    }

    private org.graylog2.dashboards.Dashboard createDashboard(String bundleId, Dashboard dashboardDescription, String userName) throws ValidationException, DashboardWidget.NoSuchWidgetTypeException, InvalidRangeParametersException, InvalidWidgetConfigurationException {
        HashMap<String, Object> dashboardData = new HashMap<String, Object>();
        dashboardData.put("title", dashboardDescription.getTitle());
        dashboardData.put("description", dashboardDescription.getDescription());
        dashboardData.put("content_pack", bundleId);
        dashboardData.put("creator_user_id", userName);
        dashboardData.put("created_at", Tools.nowUTC());
        DashboardImpl dashboard = new DashboardImpl(dashboardData);
        String dashboardId = this.dashboardService.save(dashboard);
        ImmutableList.Builder widgetPositions = ImmutableList.builder();
        for (DashboardWidget dashboardWidget : dashboardDescription.getDashboardWidgets()) {
            org.graylog2.dashboards.widgets.DashboardWidget widget = this.createDashboardWidget(dashboardWidget, userName);
            this.dashboardService.addWidget(dashboard, widget);
            WidgetPositionsRequest.WidgetPosition widgetPosition = WidgetPositionsRequest.WidgetPosition.create(widget.getId(), dashboardWidget.getCol(), dashboardWidget.getRow(), dashboardWidget.getHeight(), dashboardWidget.getWidth());
            widgetPositions.add((Object)widgetPosition);
        }
        try {
            org.graylog2.dashboards.Dashboard persistedDashboard = this.dashboardService.load(dashboardId);
            this.dashboardService.updateWidgetPositions(persistedDashboard, WidgetPositionsRequest.create((List<WidgetPositionsRequest.WidgetPosition>)widgetPositions.build()));
        }
        catch (NotFoundException e) {
            LOG.error("Failed to load dashboard with id " + dashboardId, (Throwable)e);
        }
        return dashboard;
    }

    private org.graylog2.dashboards.widgets.DashboardWidget createDashboardWidget(DashboardWidget dashboardWidget, String userName) throws InvalidRangeParametersException, DashboardWidget.NoSuchWidgetTypeException, InvalidWidgetConfigurationException {
        String type = dashboardWidget.getType();
        Map<String, Object> config = dashboardWidget.getConfiguration();
        String streamReference = (String)config.get("stream_id");
        if (!Strings.isNullOrEmpty((String)streamReference)) {
            org.graylog2.plugin.streams.Stream stream = this.streamsByReferenceId.get(streamReference);
            if (null != stream) {
                config.put("stream_id", stream.getId());
            } else {
                LOG.warn("Couldn't find referenced stream {}", (Object)streamReference);
            }
        }
        Map timerangeConfig = (Map)config.get("timerange");
        TimeRange timeRange = this.timeRangeFactory.create(timerangeConfig);
        String widgetId = UUID.randomUUID().toString();
        return this.dashboardWidgetCreator.buildDashboardWidget(type, widgetId, dashboardWidget.getDescription(), dashboardWidget.getCacheTime(), config, timeRange, userName);
    }
}

