/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.decorators;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mongodb.DBCollection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.decorators.Decorator;
import org.graylog2.decorators.DecoratorImpl;
import org.graylog2.decorators.DecoratorService;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;

public class DecoratorServiceImpl
implements DecoratorService {
    private final JacksonDBCollection<DecoratorImpl, String> coll;

    @Inject
    public DecoratorServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mongoJackObjectMapperProvider) {
        String collectionName = DecoratorImpl.class.getAnnotation(CollectionName.class).value();
        DBCollection dbCollection = mongoConnection.getDatabase().getCollection(collectionName);
        this.coll = JacksonDBCollection.wrap((DBCollection)dbCollection, DecoratorImpl.class, String.class, (ObjectMapper)mongoJackObjectMapperProvider.get());
    }

    @Override
    public List<Decorator> findForStream(String streamId) {
        return this.toInterfaceList(this.coll.find(DBQuery.is((String)"stream", Optional.of(streamId))).toArray());
    }

    @Override
    public List<Decorator> findForGlobal() {
        return this.toInterfaceList(this.coll.find(DBQuery.or((DBQuery.Query[])new DBQuery.Query[]{DBQuery.notExists((String)"stream"), DBQuery.is((String)"stream", Optional.empty())})).toArray());
    }

    @Override
    public Decorator findById(String decoratorId) throws NotFoundException {
        Decorator result = (Decorator)this.coll.findOneById((Object)decoratorId);
        if (result == null) {
            throw new NotFoundException("Decorator with id " + decoratorId + " not found.");
        }
        return result;
    }

    @Override
    public List<Decorator> findAll() {
        return this.toInterfaceList(this.coll.find().toArray());
    }

    @Override
    public Decorator create(String type, Map<String, Object> config, String stream, int order) {
        return DecoratorImpl.create(type, config, Optional.of(stream), order);
    }

    @Override
    public Decorator create(String type, Map<String, Object> config, int order) {
        return DecoratorImpl.create(type, config, order);
    }

    @Override
    public Decorator save(Decorator decorator) {
        Preconditions.checkArgument((boolean)(decorator instanceof DecoratorImpl), (String)"Argument must be an instance of DecoratorImpl, not %s", (Object[])new Object[]{decorator.getClass()});
        if (!Strings.isNullOrEmpty((String)decorator.id())) {
            this.coll.updateById((Object)decorator.id(), (Object)((DecoratorImpl)decorator));
            return (Decorator)this.coll.findOneById((Object)decorator.id());
        }
        return (Decorator)this.coll.save((Object)((DecoratorImpl)decorator)).getSavedObject();
    }

    @Override
    public int delete(String id) {
        return this.coll.removeById((Object)id).getN();
    }

    private List<Decorator> toInterfaceList(List<DecoratorImpl> concreteList) {
        return concreteList.stream().collect(Collectors.toList());
    }
}

