/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.filters;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.filters.MessageFilter;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.rest.models.system.inputs.responses.InputCreated;
import org.graylog2.rest.models.system.inputs.responses.InputDeleted;
import org.graylog2.rest.models.system.inputs.responses.InputUpdated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractorFilter
implements MessageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractorFilter.class);
    private static final String NAME = "Extractor";
    private final ConcurrentMap<String, List<Extractor>> extractors = new ConcurrentHashMap<String, List<Extractor>>();
    private final InputService inputService;
    private final ScheduledExecutorService scheduler;

    @Inject
    public ExtractorFilter(InputService inputService, EventBus serverEventBus, @Named(value="daemonScheduler") ScheduledExecutorService scheduler) {
        this.inputService = inputService;
        this.scheduler = scheduler;
        this.loadAllExtractors();
        serverEventBus.register((Object)this);
    }

    @Override
    public boolean filter(Message msg) {
        if (msg.getSourceInputId() == null) {
            return false;
        }
        for (Extractor extractor : this.extractors.getOrDefault(msg.getSourceInputId(), Collections.emptyList())) {
            try {
                extractor.runExtractor(msg);
            }
            catch (Exception e) {
                extractor.incrementExceptions();
                LOG.error("Could not apply extractor \"" + extractor.getTitle() + "\" (id=" + extractor.getId() + ") " + "to message " + msg.getId(), (Throwable)e);
            }
        }
        return false;
    }

    @Subscribe
    public void handleInputCreate(InputCreated event) {
        LOG.debug("Load extractors for input <{}>", (Object)event.id());
        this.scheduler.submit(() -> this.loadExtractors(event.id()));
    }

    @Subscribe
    public void handleInputDelete(InputDeleted event) {
        LOG.debug("Removing input from extractors cache <{}>", (Object)event.id());
        this.extractors.remove(event.id());
    }

    @Subscribe
    public void handleInputUpdate(InputUpdated event) {
        this.scheduler.submit(() -> this.loadExtractors(event.id()));
    }

    private void loadAllExtractors() {
        try {
            this.inputService.all().forEach(input -> this.loadExtractors(input.getId()));
        }
        catch (Exception e) {
            LOG.error("Unable to load extractors for all inputs", (Throwable)e);
        }
    }

    private void loadExtractors(String inputId) {
        LOG.debug("Re-loading extractors for input <{}>", (Object)inputId);
        try {
            Input input = this.inputService.find(inputId);
            List sortedExtractors = this.inputService.getExtractors(input).stream().sorted((e1, e2) -> e1.getOrder().intValue() - e2.getOrder().intValue()).collect(Collectors.toList());
            this.extractors.put(inputId, (List<Extractor>)ImmutableList.copyOf(sortedExtractors));
        }
        catch (NotFoundException e) {
            LOG.warn("Unable to load input <{}>: {}", (Object)inputId, (Object)e.getMessage());
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPriority() {
        return 10;
    }
}

