/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.retention.strategies;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.retention.strategies.AbstractIndexCountBasedRetentionStrategy;
import org.graylog2.indexer.retention.strategies.ClosingRetentionStrategyConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosingRetentionStrategy
extends AbstractIndexCountBasedRetentionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ClosingRetentionStrategy.class);
    private final Indices indices;
    private final NodeId nodeId;
    private final ClusterConfigService clusterConfigService;
    private final AuditEventSender auditEventSender;

    @Inject
    public ClosingRetentionStrategy(Deflector deflector, Indices indices, ActivityWriter activityWriter, NodeId nodeId, ClusterConfigService clusterConfigService, AuditEventSender auditEventSender) {
        super(deflector, indices, activityWriter);
        this.indices = indices;
        this.nodeId = nodeId;
        this.clusterConfigService = clusterConfigService;
        this.auditEventSender = auditEventSender;
    }

    @Override
    protected Optional<Integer> getMaxNumberOfIndices() {
        ClosingRetentionStrategyConfig config = this.clusterConfigService.get(ClosingRetentionStrategyConfig.class);
        if (config != null) {
            return Optional.of(config.maxNumberOfIndices());
        }
        return Optional.empty();
    }

    @Override
    public void retain(String indexName) {
        Stopwatch sw = Stopwatch.createStarted();
        this.indices.close(indexName);
        this.auditEventSender.success(AuditActor.system(this.nodeId), "server:es_index_retention:close", (Map<String, Object>)ImmutableMap.of((Object)"index_name", (Object)indexName, (Object)"retention_strategy", (Object)this.getClass().getCanonicalName()));
        LOG.info("Finished index retention strategy [close] for index <{}> in {}ms.", (Object)indexName, (Object)sw.stop().elapsed(TimeUnit.MILLISECONDS));
    }

    @Override
    public Class<? extends RetentionStrategyConfig> configurationClass() {
        return ClosingRetentionStrategyConfig.class;
    }

    @Override
    public RetentionStrategyConfig defaultConfiguration() {
        return ClosingRetentionStrategyConfig.createDefault();
    }
}

