/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation.strategies;

import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.indices.IndexStatistics;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.rotation.strategies.AbstractRotationStrategy;
import org.graylog2.indexer.rotation.strategies.SizeBasedRotationStrategyConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeBasedRotationStrategy
extends AbstractRotationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SizeBasedRotationStrategy.class);
    private final Indices indices;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public SizeBasedRotationStrategy(Indices indices, Deflector deflector, ClusterConfigService clusterConfigService, NodeId nodeId, AuditEventSender auditEventSender) {
        super(deflector, auditEventSender, nodeId);
        this.indices = indices;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public Class<? extends RotationStrategyConfig> configurationClass() {
        return SizeBasedRotationStrategyConfig.class;
    }

    @Override
    public RotationStrategyConfig defaultConfiguration() {
        return SizeBasedRotationStrategyConfig.createDefault();
    }

    @Override
    @Nullable
    protected AbstractRotationStrategy.Result shouldRotate(final String index) {
        final SizeBasedRotationStrategyConfig config = this.clusterConfigService.get(SizeBasedRotationStrategyConfig.class);
        if (config == null) {
            LOG.warn("No rotation strategy configuration found, not running index rotation!");
            return null;
        }
        IndexStatistics indexStats = this.indices.getIndexStats(index);
        if (indexStats == null) {
            return null;
        }
        final long sizeInBytes = indexStats.primaries().getStore().getSizeInBytes();
        final boolean shouldRotate = sizeInBytes > config.maxSize();
        return new AbstractRotationStrategy.Result(){
            public final MessageFormat ROTATE = new MessageFormat("Storage size for index <{0}> is {1} bytes, exceeding the maximum of {2} bytes. Rotating index.", Locale.ENGLISH);
            public final MessageFormat NOT_ROTATE = new MessageFormat("Storage size for index <{0}> is {1} bytes, below the maximum of {2} bytes. Not doing anything.", Locale.ENGLISH);

            @Override
            public String getDescription() {
                MessageFormat format = this.shouldRotate() ? this.ROTATE : this.NOT_ROTATE;
                return format.format(new Object[]{index, sizeInBytes, config.maxSize()});
            }

            @Override
            public boolean shouldRotate() {
                return shouldRotate;
            }
        };
    }
}

