/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation.strategies;

import com.google.common.base.MoreObjects;
import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.rotation.strategies.AbstractRotationStrategy;
import org.graylog2.indexer.rotation.strategies.TimeBasedRotationStrategyConfig;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.plugin.system.NodeId;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TimeBasedRotationStrategy
extends AbstractRotationStrategy {
    private static final Logger log = LoggerFactory.getLogger(TimeBasedRotationStrategy.class);
    private final Indices indices;
    private final ClusterConfigService clusterConfigService;
    private DateTime lastRotation;
    private DateTime anchor;

    @Inject
    public TimeBasedRotationStrategy(Indices indices, Deflector deflector, NodeId nodeId, ClusterConfigService clusterConfigService, AuditEventSender auditEventSender) {
        super(deflector, auditEventSender, nodeId);
        this.clusterConfigService = clusterConfigService;
        this.anchor = null;
        this.lastRotation = null;
        this.indices = indices;
    }

    @Override
    public Class<? extends RotationStrategyConfig> configurationClass() {
        return TimeBasedRotationStrategyConfig.class;
    }

    @Override
    public RotationStrategyConfig defaultConfiguration() {
        return TimeBasedRotationStrategyConfig.createDefault();
    }

    protected static DateTime determineRotationPeriodAnchor(@Nullable DateTime lastAnchor, Period period) {
        Period normalized = period.normalizedStandard();
        int years = normalized.getYears();
        int months = normalized.getMonths();
        int weeks = normalized.getWeeks();
        int days = normalized.getDays();
        int hours = normalized.getHours();
        int minutes = normalized.getMinutes();
        int seconds = normalized.getSeconds();
        if (years == 0 && months == 0 && weeks == 0 && days == 0 && hours == 0 && minutes == 0 && seconds == 0) {
            throw new IllegalArgumentException("Invalid rotation period specified");
        }
        DateTimeFieldType largestStrideType = null;
        if (seconds > 0) {
            largestStrideType = DateTimeFieldType.secondOfMinute();
        }
        if (minutes > 0) {
            largestStrideType = DateTimeFieldType.minuteOfHour();
        }
        if (hours > 0) {
            largestStrideType = DateTimeFieldType.hourOfDay();
        }
        if (days > 0) {
            largestStrideType = DateTimeFieldType.dayOfMonth();
        }
        if (weeks > 0) {
            largestStrideType = DateTimeFieldType.weekOfWeekyear();
        }
        if (months > 0) {
            largestStrideType = DateTimeFieldType.monthOfYear();
        }
        if (years > 0) {
            largestStrideType = DateTimeFieldType.year();
        }
        if (largestStrideType == null) {
            throw new IllegalArgumentException("Could not determine rotation stride length.");
        }
        DateTime anchorTime = (DateTime)MoreObjects.firstNonNull((Object)lastAnchor, (Object)Tools.nowUTC());
        DateTimeField field = largestStrideType.getField(anchorTime.getChronology());
        int periodValue = normalized.get(largestStrideType.getDurationType());
        long fieldValue = field.roundFloor(anchorTime.getMillis());
        int fieldValueInUnit = field.get(fieldValue);
        if (periodValue == 0) {
            log.warn("Determining stride length failed because of a 0 period. Defaulting back to 1 period to avoid crashing, but this is a bug!");
            periodValue = 1;
        }
        long difference = fieldValueInUnit % periodValue;
        long newValue = field.add(fieldValue, -1L * difference);
        return new DateTime(newValue, DateTimeZone.UTC);
    }

    @Override
    @Nullable
    protected AbstractRotationStrategy.Result shouldRotate(String index) {
        DateTime tmpAnchor;
        DateTime nextRotation;
        TimeBasedRotationStrategyConfig config = this.clusterConfigService.get(TimeBasedRotationStrategyConfig.class);
        if (config == null) {
            log.warn("No rotation strategy configuration found, not running index rotation!");
            return null;
        }
        Period rotationPeriod = config.rotationPeriod().normalizedStandard();
        DateTime now = Tools.nowUTC();
        if (this.lastRotation == null) {
            this.lastRotation = this.indices.indexCreationDate(index);
            this.anchor = TimeBasedRotationStrategy.determineRotationPeriodAnchor(this.lastRotation, rotationPeriod);
            if (this.lastRotation == null) {
                return new SimpleResult(true, "No known previous rotation time, forcing index rotation now.");
            }
        }
        if ((nextRotation = this.anchor.plus((ReadablePeriod)rotationPeriod)).isAfter((ReadableInstant)now)) {
            String message = new MessageFormat("Next rotation at {0}", Locale.ENGLISH).format(new Object[]{nextRotation});
            return new SimpleResult(false, message);
        }
        int multiplicator = 0;
        while ((tmpAnchor = this.anchor.withPeriodAdded((ReadablePeriod)rotationPeriod, ++multiplicator)).isBefore((ReadableInstant)now)) {
        }
        this.anchor = this.anchor.withPeriodAdded((ReadablePeriod)rotationPeriod, multiplicator - 1);
        this.lastRotation = now;
        String message = new MessageFormat("Rotation period {0} elapsed, next rotation at {1}", Locale.ENGLISH).format(new Object[]{this.lastRotation, this.anchor});
        return new SimpleResult(true, message);
    }

    private static class SimpleResult
    implements AbstractRotationStrategy.Result {
        private final String message;
        private final boolean rotate;

        public SimpleResult(boolean rotate, String message) {
            this.message = message;
            this.rotate = rotate;
            log.debug("{} because of: {}", (Object)(rotate ? "Rotating" : "Not rotating"), (Object)message);
        }

        @Override
        public String getDescription() {
            return this.message;
        }

        @Override
        public boolean shouldRotate() {
            return this.rotate;
        }
    }
}

