/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.extractors;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oi.thekraken.grok.api.Grok;
import oi.thekraken.grok.api.Match;
import oi.thekraken.grok.api.exception.GrokException;
import org.graylog2.ConfigurationException;
import org.graylog2.grok.GrokPattern;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.plugin.inputs.Extractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrokExtractor
extends Extractor {
    private static final Logger log = LoggerFactory.getLogger(GrokExtractor.class);
    private final Grok grok = new Grok();

    public GrokExtractor(MetricRegistry metricRegistry, Set<GrokPattern> grokPatterns, String id, String title, long order, Extractor.CursorStrategy cursorStrategy, String sourceField, String targetField, Map<String, Object> extractorConfig, String creatorUserId, List<Converter> converters, Extractor.ConditionType conditionType, String conditionValue) throws Extractor.ReservedFieldException, ConfigurationException {
        super(metricRegistry, id, title, order, Extractor.Type.GROK, cursorStrategy, sourceField, targetField, extractorConfig, creatorUserId, converters, conditionType, conditionValue);
        if (extractorConfig == null || Strings.isNullOrEmpty((String)((String)extractorConfig.get("grok_pattern")))) {
            throw new ConfigurationException("grok_pattern not set");
        }
        boolean namedCapturesOnly = (Boolean)extractorConfig.getOrDefault("named_captures_only", false);
        try {
            for (GrokPattern grokPattern : grokPatterns) {
                this.grok.addPattern(grokPattern.name, grokPattern.pattern);
            }
            this.grok.compile((String)extractorConfig.get("grok_pattern"), namedCapturesOnly);
        }
        catch (GrokException e) {
            log.error("Unable to parse grok patterns", (Throwable)e);
            throw new ConfigurationException("Unable to parse grok patterns");
        }
    }

    @Override
    protected Extractor.Result[] run(String value) {
        Match match = this.grok.match(value);
        match.captures();
        Map matches = match.toMap();
        ArrayList results = Lists.newArrayListWithCapacity((int)matches.size());
        for (Map.Entry entry : matches.entrySet()) {
            if (entry.getValue() == null) continue;
            results.add(new Extractor.Result(entry.getValue(), (String)entry.getKey(), -1, -1));
        }
        return results.toArray(new Extractor.Result[results.size()]);
    }
}

