/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.mongodb.MongoException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.bundles.BundleService;
import org.graylog2.bundles.ConfigurationBundle;
import org.graylog2.bundles.ContentPackLoaderConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentPackLoaderPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(ContentPackLoaderPeriodical.class);
    private static final HashFunction HASH_FUNCTION = Hashing.sha256();
    private static final String FILENAME_GLOB = "*.json";
    private final ObjectMapper objectMapper;
    private final BundleService bundleService;
    private final ClusterConfigService clusterConfigService;
    private final UserService userService;
    private final boolean contentPacksLoaderEnabled;
    private final Path contentPacksDir;
    private final Set<String> contentPacksAutoLoad;

    @Inject
    public ContentPackLoaderPeriodical(ObjectMapper objectMapper, BundleService bundleService, ClusterConfigService clusterConfigService, UserService userService, @Named(value="content_packs_loader_enabled") boolean contentPacksLoaderEnabled, @Named(value="content_packs_dir") Path contentPacksDir, @Named(value="content_packs_auto_load") Set<String> contentPacksAutoLoad) {
        this.objectMapper = objectMapper;
        this.bundleService = bundleService;
        this.clusterConfigService = clusterConfigService;
        this.userService = userService;
        this.contentPacksLoaderEnabled = contentPacksLoaderEnabled;
        this.contentPacksDir = contentPacksDir;
        this.contentPacksAutoLoad = ImmutableSet.copyOf(contentPacksAutoLoad);
    }

    @Override
    public boolean runsForever() {
        return true;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return this.contentPacksLoaderEnabled;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void doRun() {
        String fileName;
        ContentPackLoaderConfig contentPackLoaderConfig = this.clusterConfigService.getOrDefault(ContentPackLoaderConfig.class, ContentPackLoaderConfig.EMPTY);
        List<Path> files = this.getFiles(this.contentPacksDir, FILENAME_GLOB);
        HashMap<String, ConfigurationBundle> contentPacks = new HashMap<String, ConfigurationBundle>(files.size());
        HashSet<String> loadedContentPacks = new HashSet<String>(contentPackLoaderConfig.loadedContentPacks());
        HashSet<String> appliedContentPacks = new HashSet<String>(contentPackLoaderConfig.appliedContentPacks());
        HashMap<String, String> checksums = new HashMap<String, String>(contentPackLoaderConfig.checksums());
        for (Path path : files) {
            ConfigurationBundle insertedContentPack;
            ConfigurationBundle contentPack;
            byte[] bytes;
            fileName = path.getFileName().toString();
            LOG.debug("Reading content pack from {}", (Object)path);
            try {
                bytes = Files.readAllBytes(path);
            }
            catch (IOException e) {
                LOG.warn("Couldn't read " + path + ". Skipping.", (Throwable)e);
                continue;
            }
            String encodedFileName = this.encodeFileNameForMongo(fileName);
            String checksum = HASH_FUNCTION.hashBytes(bytes).toString();
            String storedChecksum = (String)checksums.get(encodedFileName);
            if (storedChecksum == null) {
                checksums.put(encodedFileName, checksum);
            } else if (!checksum.equals(storedChecksum)) {
                LOG.info("Checksum of {} changed (expected: {}, actual: {})", new Object[]{path, storedChecksum, checksum});
                continue;
            }
            if (contentPackLoaderConfig.loadedContentPacks().contains(fileName)) {
                LOG.debug("Skipping already loaded content pack {} (SHA-256: {})", (Object)path, (Object)storedChecksum);
                continue;
            }
            LOG.debug("Parsing content pack from {}", (Object)path);
            try {
                contentPack = (ConfigurationBundle)this.objectMapper.readValue(bytes, ConfigurationBundle.class);
            }
            catch (IOException e) {
                LOG.warn("Couldn't parse content pack in file " + path + ". Skipping", (Throwable)e);
                continue;
            }
            ConfigurationBundle existingContentPack = this.bundleService.findByNameAndCategory(contentPack.getName(), contentPack.getCategory());
            if (existingContentPack != null) {
                LOG.debug("Content pack {}/{} already exists in database. Skipping.", (Object)contentPack.getCategory(), (Object)contentPack.getName());
                contentPacks.put(fileName, existingContentPack);
                continue;
            }
            try {
                insertedContentPack = this.bundleService.insert(contentPack);
                LOG.debug("Successfully inserted content pack {} into database with ID {}", (Object)path, (Object)insertedContentPack.getId());
            }
            catch (MongoException e) {
                LOG.error("Error while inserting content pack " + path + " into database. Skipping.", (Throwable)e);
                continue;
            }
            contentPacks.put(fileName, insertedContentPack);
            loadedContentPacks.add(fileName);
        }
        LOG.debug("Applying selected content packs");
        for (Map.Entry entry : contentPacks.entrySet()) {
            fileName = (String)entry.getKey();
            ConfigurationBundle contentPack = (ConfigurationBundle)entry.getValue();
            if (this.contentPacksAutoLoad.contains(fileName) && appliedContentPacks.contains(fileName)) {
                LOG.debug("Content pack {}/{} ({}) already applied. Skipping.", new Object[]{contentPack.getName(), contentPack.getCategory(), fileName});
                continue;
            }
            if (!this.contentPacksAutoLoad.contains(fileName)) continue;
            LOG.debug("Applying content pack {}/{} ({})", new Object[]{contentPack.getName(), contentPack.getCategory(), fileName});
            this.bundleService.applyConfigurationBundle(contentPack, this.userService.getAdminUser());
            appliedContentPacks.add(fileName);
        }
        ContentPackLoaderConfig changedContentPackLoaderConfig = ContentPackLoaderConfig.create(loadedContentPacks, appliedContentPacks, checksums);
        if (!contentPackLoaderConfig.equals(changedContentPackLoaderConfig)) {
            this.clusterConfigService.write(changedContentPackLoaderConfig);
        }
    }

    private String encodeFileNameForMongo(String fileName) {
        return fileName.replace('.', '*');
    }

    private List<Path> getFiles(Path rootPath, String glob) {
        ImmutableList.Builder files = ImmutableList.builder();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(rootPath, glob);){
            for (Path path : directoryStream) {
                if (!Files.isReadable(path)) {
                    LOG.debug("Skipping unreadable file {}", (Object)path);
                }
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    LOG.debug("Path {} is not a regular file. Skipping.");
                }
                files.add((Object)path);
            }
        }
        catch (IOException e) {
            LOG.error("Couldn't list content packs", (Throwable)e);
        }
        return files.build();
    }
}

