/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inputs;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.database.EmbeddedPersistable;
import org.graylog2.plugin.inputs.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Extractor
implements EmbeddedPersistable {
    private static final Logger LOG = LoggerFactory.getLogger(Extractor.class);
    public static final String FIELD_ID = "id";
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_ORDER = "order";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_CURSOR_STRATEGY = "cursor_strategy";
    public static final String FIELD_TARGET_FIELD = "target_field";
    public static final String FIELD_SOURCE_FIELD = "source_field";
    public static final String FIELD_CREATOR_USER_ID = "creator_user_id";
    public static final String FIELD_EXTRACTOR_CONFIG = "extractor_config";
    public static final String FIELD_CONDITION_TYPE = "condition_type";
    public static final String FIELD_CONDITION_VALUE = "condition_value";
    public static final String FIELD_CONVERTERS = "converters";
    public static final String FIELD_CONVERTER_TYPE = "type";
    public static final String FIELD_CONVERTER_CONFIG = "config";
    public static final ResultPredicate VALUE_NULL_PREDICATE = new ResultPredicate();
    protected final AtomicLong exceptions;
    protected final AtomicLong converterExceptions;
    protected final String id;
    protected final String title;
    protected final Type superType;
    protected final CursorStrategy cursorStrategy;
    protected final String targetField;
    protected final String sourceField;
    protected final String creatorUserId;
    protected final Map<String, Object> extractorConfig;
    protected final List<Converter> converters;
    protected final ConditionType conditionType;
    protected final String conditionValue;
    protected long order;
    protected Pattern regexConditionPattern;
    private final String totalTimerName;
    private final String converterTimerName;
    protected final MetricRegistry metricRegistry;

    protected abstract Result[] run(String var1);

    public Extractor(MetricRegistry metricRegistry, String id, String title, long order, Type type, CursorStrategy cursorStrategy, String sourceField, String targetField, Map<String, Object> extractorConfig, String creatorUserId, List<Converter> converters, ConditionType conditionType, String conditionValue) throws ReservedFieldException {
        this.metricRegistry = metricRegistry;
        if (Message.RESERVED_FIELDS.contains((Object)targetField) && !Message.RESERVED_SETTABLE_FIELDS.contains((Object)targetField)) {
            throw new ReservedFieldException("You cannot apply an extractor on reserved field [" + targetField + "].");
        }
        this.exceptions = new AtomicLong(0L);
        this.converterExceptions = new AtomicLong(0L);
        this.id = id;
        this.title = title;
        this.order = order;
        this.superType = type;
        this.cursorStrategy = cursorStrategy;
        this.targetField = targetField;
        this.sourceField = sourceField;
        this.extractorConfig = extractorConfig;
        this.creatorUserId = creatorUserId;
        this.converters = converters;
        this.conditionType = conditionType;
        this.conditionValue = conditionValue;
        if (conditionType.equals((Object)ConditionType.REGEX)) {
            this.regexConditionPattern = Pattern.compile(conditionValue, 32);
        }
        this.totalTimerName = MetricRegistry.name(this.getClass(), (String[])new String[]{this.getType().toString().toLowerCase(Locale.ENGLISH), this.getId(), "executionTime"});
        this.converterTimerName = MetricRegistry.name(this.getClass(), (String[])new String[]{this.getType().toString().toLowerCase(Locale.ENGLISH), this.getId(), "converterExecutionTime"});
    }

    public void runExtractor(Message msg) {
        if (!(msg.getField(this.sourceField) instanceof String)) {
            return;
        }
        String field = (String)msg.getField(this.sourceField);
        if (this.conditionType.equals((Object)ConditionType.STRING) ? !field.contains(this.conditionValue) : this.conditionType.equals((Object)ConditionType.REGEX) && !this.regexConditionPattern.matcher(field).find()) {
            return;
        }
        Timer.Context timerContext = this.metricRegistry.timer(this.getTotalTimerName()).time();
        Object[] results = this.run(field);
        if (results == null || results.length == 0 || FluentIterable.of((Object[])results).anyMatch((Predicate)VALUE_NULL_PREDICATE)) {
            timerContext.close();
            return;
        }
        if (results.length == 1 && ((Result)results[0]).target == null) {
            msg.addField(this.targetField, ((Result)results[0]).getValue());
        } else {
            for (Object result : results) {
                msg.addField(((Result)result).getTarget(), ((Result)result).getValue());
            }
        }
        if (this.cursorStrategy.equals((Object)CursorStrategy.CUT) && !this.targetField.equals(this.sourceField) && !Message.RESERVED_FIELDS.contains((Object)this.sourceField) && ((Result)results[0]).beginIndex != -1) {
            StringBuilder sb = new StringBuilder(field);
            ImmutableList reverseList = FluentIterable.from(Arrays.asList(results)).toSortedList((Comparator)new Comparator<Result>(){

                @Override
                public int compare(Result left, Result right) {
                    return -1 * ComparisonChain.start().compare(left.endIndex, right.endIndex).result();
                }
            });
            for (Object result : reverseList) {
                sb.delete(((Result)result).getBeginIndex(), ((Result)result).getEndIndex());
            }
            String finalResult = sb.toString();
            if (finalResult.trim().isEmpty()) {
                finalResult = "fullyCutByExtractor";
            }
            msg.removeField(this.sourceField);
            msg.addField(this.sourceField, finalResult);
        }
        this.runConverters(msg);
        timerContext.stop();
    }

    public void runConverters(Message msg) {
        Timer.Context timerContext = this.metricRegistry.timer(this.getConverterTimerName()).time();
        for (Converter converter : this.converters) {
            try {
                if (!(msg.getField(this.targetField) instanceof String)) continue;
                Object convertedValue = converter.convert((String)msg.getField(this.targetField));
                if (!converter.buildsMultipleFields()) {
                    msg.removeField(this.targetField);
                    msg.addField(this.targetField, convertedValue);
                    continue;
                }
                if (!(convertedValue instanceof Map)) continue;
                HashMap<String, Object> additionalFields = new HashMap<String, Object>((Map)convertedValue);
                for (String reservedField : Message.RESERVED_FIELDS) {
                    if (!additionalFields.containsKey(reservedField)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Not setting reserved field {} from converter {} on message {}, rest of the message is being processed", new Object[]{reservedField, converter.getType(), msg.getId()});
                    }
                    this.converterExceptions.incrementAndGet();
                    additionalFields.remove(reservedField);
                }
                msg.addFields(additionalFields);
            }
            catch (Exception e) {
                this.converterExceptions.incrementAndGet();
                LOG.error("Could not apply converter [" + converter.getType() + "] of extractor [" + this.getId() + "].", (Throwable)e);
            }
        }
        timerContext.stop();
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Long getOrder() {
        return this.order;
    }

    public void setOrder(long order) {
        this.order = order;
    }

    public Type getType() {
        return this.superType;
    }

    public CursorStrategy getCursorStrategy() {
        return this.cursorStrategy;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public String getSourceField() {
        return this.sourceField;
    }

    public Map<String, Object> getExtractorConfig() {
        return this.extractorConfig;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    public String getConditionValue() {
        return this.conditionValue;
    }

    public ConditionType getConditionType() {
        return this.conditionType;
    }

    @Override
    public Map<String, Object> getPersistedFields() {
        return ImmutableMap.builder().put((Object)FIELD_ID, (Object)this.id).put((Object)FIELD_TITLE, (Object)this.title).put((Object)FIELD_ORDER, (Object)this.order).put((Object)"type", (Object)this.superType.toString().toLowerCase(Locale.ENGLISH)).put((Object)FIELD_CURSOR_STRATEGY, (Object)this.cursorStrategy.toString().toLowerCase(Locale.ENGLISH)).put((Object)FIELD_TARGET_FIELD, (Object)this.targetField).put((Object)FIELD_SOURCE_FIELD, (Object)this.sourceField).put((Object)FIELD_CREATOR_USER_ID, (Object)this.creatorUserId).put((Object)FIELD_EXTRACTOR_CONFIG, this.extractorConfig).put((Object)FIELD_CONDITION_TYPE, (Object)this.conditionType.toString().toLowerCase(Locale.ENGLISH)).put((Object)FIELD_CONDITION_VALUE, (Object)this.conditionValue).put((Object)FIELD_CONVERTERS, this.converterConfigMap()).build();
    }

    public List<Converter> getConverters() {
        return this.converters;
    }

    public List<Map<String, Object>> converterConfigMap() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Converter converter : this.converters) {
            ImmutableMap config = ImmutableMap.of((Object)"type", (Object)converter.getType().toLowerCase(Locale.ENGLISH), (Object)FIELD_CONVERTER_CONFIG, converter.getConfig());
            listBuilder.add((Object)config);
        }
        return listBuilder.build();
    }

    public String getTotalTimerName() {
        return this.totalTimerName;
    }

    public String getConverterTimerName() {
        return this.converterTimerName;
    }

    public long getExceptionCount() {
        return this.exceptions.get();
    }

    public long getConverterExceptionCount() {
        return this.converterExceptions.get();
    }

    public void incrementExceptions() {
        this.exceptions.incrementAndGet();
    }

    private static class ResultPredicate
    implements Predicate<Result> {
        private ResultPredicate() {
        }

        public boolean apply(Result input) {
            return input.getValue() == null;
        }
    }

    public static class Result {
        private final Object value;
        private final String target;
        private final int beginIndex;
        private final int endIndex;

        public Result(String value, int beginIndex, int endIndex) {
            this(value, null, beginIndex, endIndex);
        }

        public Result(Object value, String target, int beginIndex, int endIndex) {
            this.value = value;
            this.target = target;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        public Object getValue() {
            return this.value;
        }

        public String getTarget() {
            return this.target;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return Objects.equals(this.beginIndex, result.beginIndex) && Objects.equals(this.endIndex, result.endIndex) && Objects.equals(this.value, result.value) && Objects.equals(this.target, result.target);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.target, this.beginIndex, this.endIndex);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("target", (Object)this.target).add("beginIndex", this.beginIndex).add("endIndex", this.endIndex).toString();
        }
    }

    public static class ReservedFieldException
    extends Exception {
        public ReservedFieldException(String msg) {
            super(msg);
        }
    }

    public static enum ConditionType {
        NONE,
        STRING,
        REGEX;

    }

    public static enum CursorStrategy {
        CUT,
        COPY;

    }

    public static enum Type {
        SUBSTRING,
        REGEX,
        REGEX_REPLACE,
        SPLIT_AND_INDEX,
        COPY_INPUT,
        GROK,
        JSON;


        public static Type fuzzyValueOf(String s) {
            try {
                return Type.valueOf(s.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

