/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.models.system.inputs.responses.InputCreated;
import org.graylog2.rest.models.system.inputs.responses.InputDeleted;
import org.graylog2.rest.models.system.inputs.responses.InputStateSummary;
import org.graylog2.rest.models.system.inputs.responses.InputStatesList;
import org.graylog2.rest.resources.system.inputs.RemoteInputStatesResource;
import org.graylog2.shared.rest.resources.ProxiedResource;

@RequiresAuthentication
@Api(value="Cluster/InputState", description="Cluster-wide input states")
@Path(value="/cluster/inputstates")
@Produces(value={"application/json"})
public class ClusterInputStatesResource
extends ProxiedResource {
    @Inject
    public ClusterInputStatesResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders) throws NodeNotFoundException {
        super(httpHeaders, nodeService, remoteInterfaceProvider);
    }

    @GET
    @Timed
    @ApiOperation(value="Get all input states")
    @RequiresPermissions(value={"inputs:read"})
    public Map<String, Optional<Set<InputStateSummary>>> get() {
        return this.getForAllNodes(RemoteInputStatesResource::list, this.createRemoteInterfaceProvider(RemoteInputStatesResource.class), InputStatesList::states);
    }

    @PUT
    @Path(value="/{inputId}")
    @Timed
    @ApiOperation(value="Start or restart specified input in all nodes")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input.")})
    @AuditEvent(type="server:message_input:start")
    public Map<String, Optional<InputCreated>> start(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) {
        return this.getForAllNodes(remoteResource -> remoteResource.start(inputId), this.createRemoteInterfaceProvider(RemoteInputStatesResource.class));
    }

    @DELETE
    @Path(value="/{inputId}")
    @Timed
    @ApiOperation(value="Stop specified input in all nodes")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input.")})
    @AuditEvent(type="server:message_input:stop")
    public Map<String, Optional<InputDeleted>> stop(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) {
        return this.getForAllNodes(remoteResource -> remoteResource.stop(inputId), this.createRemoteInterfaceProvider(RemoteInputStatesResource.class));
    }
}

