/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.graylog2.shared.rest.resources.system.RemoteLoadBalancerStatusResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

@RequiresAuthentication
@Api(value="Cluster/LoadBalancers", description="Cluster-wide status propagation for LB")
@Produces(value={"application/json"})
@Path(value="/cluster/{nodeId}/lbstatus")
public class ClusterLoadBalancerStatusResource
extends ProxiedResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterLoadBalancerStatusResource.class);

    @Inject
    public ClusterLoadBalancerStatusResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders) throws NodeNotFoundException {
        super(httpHeaders, nodeService, remoteInterfaceProvider);
    }

    @PUT
    @Timed
    @RequiresAuthentication
    @RequiresPermissions(value={"lbstatus:change"})
    @ApiOperation(value="Override load balancer status of this graylog-server node. Next lifecycle change will override it again to its default. Set to ALIVE, DEAD, or THROTTLED.")
    @Path(value="/override/{status}")
    @NoAuditEvent(value="this is a proxy resource, the audit event will be emitted on the target node")
    public void override(@ApiParam(name="nodeId", value="The id of the node whose LB status will be changed", required=true) @PathParam(value="nodeId") String nodeId, @ApiParam(name="status") @PathParam(value="status") String status) throws IOException, NodeNotFoundException {
        Node targetNode = this.nodeService.byNodeId(nodeId);
        RemoteLoadBalancerStatusResource remoteLoadBalancerStatusResource = this.remoteInterfaceProvider.get(targetNode, this.authenticationToken, RemoteLoadBalancerStatusResource.class);
        Response response = remoteLoadBalancerStatusResource.override(status).execute();
        if (!response.isSuccessful()) {
            LOG.warn("Unable to override load balancer status on node {}: {}", (Object)nodeId, (Object)response.message());
            throw new WebApplicationException(response.message(), Response.Status.BAD_GATEWAY);
        }
    }
}

