/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.models.system.SystemJobSummary;
import org.graylog2.rest.resources.system.jobs.RemoteSystemJobResource;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

@RequiresAuthentication
@Api(value="Cluster/Jobs", description="Cluster-wide System Jobs")
@Path(value="/cluster/jobs")
public class ClusterSystemJobResource
extends ProxiedResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterSystemJobResource.class);

    @Inject
    public ClusterSystemJobResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders) throws NodeNotFoundException {
        super(httpHeaders, nodeService, remoteInterfaceProvider);
    }

    @GET
    @Timed
    @ApiOperation(value="List currently running jobs")
    @Produces(value={"application/json"})
    public Map<String, Optional<Map<String, List<SystemJobSummary>>>> list() throws IOException {
        return this.getForAllNodes(RemoteSystemJobResource::list, this.createRemoteInterfaceProvider(RemoteSystemJobResource.class));
    }

    @GET
    @Path(value="{jobId}")
    @Timed
    @ApiOperation(value="Get job with the given ID")
    @Produces(value={"application/json"})
    public SystemJobSummary getJob(@ApiParam(name="jobId", required=true) @PathParam(value="jobId") String jobId) throws IOException {
        for (Map.Entry<String, Node> entry : this.nodeService.allActive().entrySet()) {
            RemoteSystemJobResource remoteSystemJobResource = this.remoteInterfaceProvider.get(entry.getValue(), this.authenticationToken, RemoteSystemJobResource.class);
            try {
                Response response = remoteSystemJobResource.get(jobId).execute();
                if (!response.isSuccessful()) continue;
                return (SystemJobSummary)response.body();
            }
            catch (IOException e) {
                LOG.warn("Unable to fetch system jobs from node {}:", (Object)entry.getKey(), (Object)e);
            }
        }
        throw new NotFoundException("System job with id " + jobId + " not found!");
    }

    @DELETE
    @Path(value="{jobId}")
    @Timed
    @ApiOperation(value="Cancel job with the given ID")
    @Produces(value={"application/json"})
    @AuditEvent(type="server:system_job:stop")
    public SystemJobSummary cancelJob(@ApiParam(name="jobId", required=true) @PathParam(value="jobId") @NotEmpty String jobId) throws IOException {
        Optional<Response> summaryResponse = this.nodeService.allActive().entrySet().stream().map(entry -> {
            RemoteSystemJobResource resource = this.remoteInterfaceProvider.get((Node)entry.getValue(), this.authenticationToken, RemoteSystemJobResource.class);
            try {
                return resource.delete(jobId).execute();
            }
            catch (IOException e) {
                LOG.warn("Unable to fetch system jobs from node {}:", entry.getKey(), (Object)e);
                return null;
            }
        }).filter(response -> response != null && response.isSuccessful()).findFirst();
        return (SystemJobSummary)summaryResponse.orElseThrow(() -> new NotFoundException("System job with ID <" + jobId + "> not found!")).body();
    }
}

