/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.graylog2.periodical.Periodicals;
import org.graylog2.plugin.Tools;
import org.slf4j.LoggerFactory;

public class SchedulerBindings
extends AbstractModule {
    private static final int SCHEDULED_THREADS_POOL_SIZE = 30;

    protected void configure() {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(30, new ThreadFactoryBuilder().setNameFormat("scheduled-%d").setDaemon(false).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new Tools.LogUncaughtExceptionHandler(LoggerFactory.getLogger((String)"org.graylog2.scheduler.Scheduler"))).build());
        this.bind(ScheduledExecutorService.class).annotatedWith((Annotation)Names.named((String)"scheduler")).toInstance((Object)scheduler);
        ScheduledExecutorService daemonScheduler = Executors.newScheduledThreadPool(30, new ThreadFactoryBuilder().setNameFormat("scheduled-daemon-%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new Tools.LogUncaughtExceptionHandler(LoggerFactory.getLogger((String)"org.graylog2.scheduler.DaemonScheduler"))).build());
        this.bind(ScheduledExecutorService.class).annotatedWith((Annotation)Names.named((String)"daemonScheduler")).toInstance((Object)daemonScheduler);
        this.bind(Periodicals.class).toInstance((Object)new Periodicals(scheduler, daemonScheduler));
    }
}

