/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.stats.mongo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.graylog2.system.stats.mongo.AutoValue_HostInfo;
import org.graylog2.system.stats.mongo.AutoValue_HostInfo_Extra;
import org.graylog2.system.stats.mongo.AutoValue_HostInfo_Os;
import org.graylog2.system.stats.mongo.AutoValue_HostInfo_System;
import org.joda.time.DateTime;

@JsonAutoDetect
public abstract class HostInfo {
    @JsonProperty
    public abstract System system();

    @JsonProperty
    public abstract Os os();

    @JsonProperty
    public abstract Extra extra();

    public static HostInfo create(System system, Os os, Extra extra) {
        return new AutoValue_HostInfo(system, os, extra);
    }

    @JsonAutoDetect
    public static abstract class Extra {
        @JsonProperty
        @Nullable
        public abstract String versionString();

        @JsonProperty
        @Nullable
        public abstract String libcVersion();

        @JsonProperty
        @Nullable
        public abstract String kernelVersion();

        @JsonProperty
        @Nullable
        public abstract String cpuFrequencyMHz();

        @JsonProperty
        @Nullable
        public abstract String cpuFeatures();

        @JsonProperty
        @Nullable
        public abstract String scheduler();

        @JsonProperty
        public abstract Long pageSize();

        @JsonProperty
        @Nullable
        public abstract Long numPages();

        @JsonProperty
        @Nullable
        public abstract Long maxOpenFiles();

        public static Extra create(@Nullable String versionString, @Nullable String libcVersion, @Nullable String kernelVersion, @Nullable String cpuFrequencyMHz, @Nullable String cpuFeatures, @Nullable String scheduler, long pageSize, @Nullable Long numPages, @Nullable Long maxOpenFiles) {
            return new AutoValue_HostInfo_Extra(versionString, libcVersion, kernelVersion, cpuFrequencyMHz, cpuFeatures, scheduler, pageSize, numPages, maxOpenFiles);
        }
    }

    @JsonAutoDetect
    public static abstract class Os {
        @JsonProperty
        public abstract String type();

        @JsonProperty
        public abstract String name();

        @JsonProperty
        public abstract String version();

        public static Os create(String type, String name, String version) {
            return new AutoValue_HostInfo_Os(type, name, version);
        }
    }

    @JsonAutoDetect
    public static abstract class System {
        @JsonProperty
        public abstract DateTime currentTime();

        @JsonProperty
        public abstract String hostname();

        @JsonProperty
        public abstract int cpuAddrSize();

        @JsonProperty
        public abstract long memSizeMB();

        @JsonProperty
        public abstract int numCores();

        @JsonProperty
        public abstract String cpuArch();

        @JsonProperty
        public abstract boolean numaEnabled();

        public static System create(DateTime currentTime, String hostname, int cpuAddrSize, long memSizeMB, int numCores, String cpuArch, boolean numaEnabled) {
            return new AutoValue_HostInfo_System(currentTime, hostname, cpuAddrSize, memSizeMB, numCores, cpuArch, numaEnabled);
        }
    }
}

