/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.alarmcallbacks.AlarmCallbackFactory;
import org.graylog2.alarmcallbacks.AlarmCallbackHistory;
import org.graylog2.alarmcallbacks.AlarmCallbackHistoryService;
import org.graylog2.alerts.Alert;
import org.graylog2.alerts.AlertService;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertScanner {
    private static final Logger LOG = LoggerFactory.getLogger(AlertScanner.class);
    private final AlertService alertService;
    private final AlarmCallbackConfigurationService alarmCallbackConfigurationService;
    private final AlarmCallbackFactory alarmCallbackFactory;
    private final AlarmCallbackHistoryService alarmCallbackHistoryService;

    @Inject
    public AlertScanner(AlertService alertService, AlarmCallbackConfigurationService alarmCallbackConfigurationService, AlarmCallbackFactory alarmCallbackFactory, AlarmCallbackHistoryService alarmCallbackHistoryService) {
        this.alertService = alertService;
        this.alarmCallbackConfigurationService = alarmCallbackConfigurationService;
        this.alarmCallbackFactory = alarmCallbackFactory;
        this.alarmCallbackHistoryService = alarmCallbackHistoryService;
    }

    private Alert handleTriggeredCheckResult(AlertCondition.CheckResult result, Stream stream, AlertCondition alertCondition) throws ValidationException {
        Alert alert = this.alertService.factory(result);
        this.alertService.save(alert);
        List<AlarmCallbackConfiguration> callConfigurations = this.alarmCallbackConfigurationService.getForStream(stream);
        for (AlarmCallbackConfiguration configuration : callConfigurations) {
            AlarmCallbackHistory alarmCallbackHistory;
            AlarmCallback alarmCallback = null;
            try {
                alarmCallback = this.alarmCallbackFactory.create(configuration);
                alarmCallback.call(stream, result);
                alarmCallbackHistory = this.alarmCallbackHistoryService.success(configuration, alert, alertCondition);
            }
            catch (Exception e) {
                if (alarmCallback != null) {
                    LOG.warn("Alarm callback <" + alarmCallback.getName() + "> failed. Skipping.", (Throwable)e);
                } else {
                    LOG.warn("Alarm callback with id " + configuration.getId() + " failed. Skipping.", (Throwable)e);
                }
                alarmCallbackHistory = this.alarmCallbackHistoryService.error(configuration, alert, alertCondition, e.getMessage());
            }
            try {
                this.alarmCallbackHistoryService.save(alarmCallbackHistory);
            }
            catch (Exception e) {
                LOG.warn("Unable to save history of alarm callback run: ", (Throwable)e);
            }
        }
        return alert;
    }

    private void handleResolveAlert(Alert alert) {
        this.alertService.resolveAlert(alert);
    }

    public boolean checkAlertCondition(Stream stream, AlertCondition alertCondition) {
        if (stream.isPaused().booleanValue() || this.alertService.inGracePeriod(alertCondition)) {
            return false;
        }
        try {
            AlertCondition.CheckResult result = alertCondition.runCheck();
            Optional<Alert> alert = this.alertService.getLastTriggeredAlert(stream.getId(), alertCondition.getId());
            if (result.isTriggered()) {
                if (!alert.isPresent() || this.alertService.isResolved(alert.get())) {
                    LOG.debug("Alert condition [{}] is triggered. Sending alerts.", (Object)alertCondition);
                    this.handleTriggeredCheckResult(result, stream, alertCondition);
                } else {
                    LOG.debug("Alert condition [{}] is triggered but alerts were already sent. Nothing to do.", (Object)alertCondition);
                }
                return true;
            }
            if (alert.isPresent() && !this.alertService.isResolved(alert.get())) {
                LOG.debug("Alert condition [{}]\u00a0is not triggered anymore. Resolving alert.", (Object)alertCondition);
                this.handleResolveAlert(alert.get());
            } else {
                LOG.debug("Alert condition [{}]\u00a0is not triggered and is marked as resolved. Nothing to do.", (Object)alertCondition);
            }
        }
        catch (Exception e) {
            LOG.error("Skipping alert check that threw an exception.", (Throwable)e);
        }
        return false;
    }
}

