/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetStats;

public class IndexSetStatsCreator {
    private final Indices indices;

    @Inject
    public IndexSetStatsCreator(Indices indices) {
        this.indices = indices;
    }

    public IndexSetStats getForIndexSet(IndexSet indexSet) {
        Map<String, IndexStats> docCounts = this.indices.getAllDocCounts(indexSet);
        Set<String> closedIndices = this.indices.getClosedIndices(indexSet);
        long documents = docCounts.values().stream().mapToLong(indexStats -> indexStats.getPrimaries().getDocs().getCount()).sum();
        long size = docCounts.values().stream().mapToLong(indexStats -> indexStats.getPrimaries().getStore().sizeInBytes()).sum();
        return IndexSetStats.create(docCounts.size() + closedIndices.size(), documents, size);
    }
}

