/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.elasticsearch;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.FilterClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.transport.TransportRequestOptions;

public class GlobalTimeoutClient
extends FilterClient {
    private final long timeout;
    private final TimeUnit unit;
    private final Counter searchRequests;

    public GlobalTimeoutClient(Client in, long timeout, TimeUnit unit, MetricRegistry metricRegistry) {
        super(in);
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        this.timeout = timeout;
        this.unit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)unit)));
        this.searchRequests = metricRegistry.counter(MetricRegistry.name(GlobalTimeoutClient.class, (String[])new String[]{"search-requests"}));
    }

    protected <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void doExecute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        super.doExecute(new GlobalTimeoutAction<Request, Response, RequestBuilder>(action, this.timeout, this.unit), request, listener);
    }

    public ActionFuture<SearchResponse> search(SearchRequest request) {
        this.searchRequests.inc();
        return super.search(request);
    }

    public void search(SearchRequest request, ActionListener<SearchResponse> listener) {
        this.searchRequests.inc();
        super.search(request, listener);
    }

    public static class GlobalTimeoutAction<Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>>
    extends Action<Request, Response, RequestBuilder> {
        private final Action<Request, Response, RequestBuilder> action;
        private final TimeValue timeout;

        public GlobalTimeoutAction(Action<Request, Response, RequestBuilder> action, long duration, TimeUnit timeUnit) {
            super(action.name());
            this.action = (Action)Preconditions.checkNotNull(action);
            this.timeout = new TimeValue(duration, timeUnit);
        }

        public TransportRequestOptions transportOptions(Settings settings) {
            TransportRequestOptions result = super.transportOptions(settings);
            if (result.timeout() == null) {
                return TransportRequestOptions.builder().withCompress(result.compress()).withType(result.type()).withTimeout(this.timeout).build();
            }
            return result;
        }

        public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
            return (RequestBuilder)this.action.newRequestBuilder(client);
        }

        public Response newResponse() {
            return (Response)this.action.newResponse();
        }
    }
}

