/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.ranges;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.TooManyAliasesException;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.system.jobs.SystemJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebuildIndexRangesJob
extends SystemJob {
    private static final Logger LOG = LoggerFactory.getLogger(RebuildIndexRangesJob.class);
    private static final int MAX_CONCURRENCY = 1;
    private volatile boolean cancelRequested = false;
    private volatile int indicesToCalculate = 0;
    private volatile int indicesCalculated = 0;
    protected final Set<IndexSet> indexSets;
    private final ActivityWriter activityWriter;
    protected final IndexRangeService indexRangeService;

    @AssistedInject
    public RebuildIndexRangesJob(@Assisted Set<IndexSet> indexSets, ActivityWriter activityWriter, IndexRangeService indexRangeService) {
        this.indexSets = indexSets;
        this.activityWriter = activityWriter;
        this.indexRangeService = indexRangeService;
    }

    @Override
    public void requestCancel() {
        this.cancelRequested = true;
    }

    @Override
    public int getProgress() {
        if (this.indicesToCalculate <= 0) {
            return 0;
        }
        return (int)Math.floor((float)this.indicesCalculated / (float)this.indicesToCalculate * 100.0f);
    }

    @Override
    public String getDescription() {
        return "Rebuilds index range information.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.info("Recalculating index ranges.");
        ListMultimap indexSets = MultimapBuilder.hashKeys().arrayListValues().build();
        for (IndexSet indexSet : this.indexSets) {
            String[] managedIndicesNames = indexSet.getManagedIndices();
            for (String name : managedIndicesNames) {
                indexSets.put((Object)indexSet, (Object)name);
            }
        }
        if (indexSets.size() == 0) {
            this.info("No indices, nothing to calculate.");
            return;
        }
        this.indicesToCalculate = indexSets.values().size();
        Stopwatch sw = Stopwatch.createStarted();
        for (IndexSet indexSet : indexSets.keySet()) {
            LOG.info("Recalculating index ranges for index set {} ({}): {} indices affected.", new Object[]{indexSet.getConfig().title(), indexSet.getIndexWildcard(), indexSets.get((Object)indexSet).size()});
            for (String index : indexSets.get((Object)indexSet)) {
                block16: {
                    try {
                        if (!index.equals(indexSet.getActiveWriteIndex())) break block16;
                        LOG.debug("{} is current write target, do not calculate index range for it", (Object)index);
                        IndexRange emptyRange = this.indexRangeService.createUnknownRange(index);
                        try {
                            IndexRange indexRange = this.indexRangeService.get(index);
                            if (indexRange.begin().getMillis() != 0L || indexRange.end().getMillis() != 0L) {
                                LOG.info("Invalid date ranges for write index {}, resetting it.", (Object)index);
                                this.indexRangeService.save(emptyRange);
                            }
                        }
                        catch (NotFoundException e) {
                            LOG.info("No index range found for write index {}, recreating it.", (Object)index);
                            this.indexRangeService.save(emptyRange);
                        }
                        ++this.indicesCalculated;
                    }
                    catch (TooManyAliasesException e) {
                        LOG.error("Multiple write alias targets found, this is a bug.");
                        ++this.indicesCalculated;
                    }
                    continue;
                }
                if (this.cancelRequested) {
                    this.info("Stop requested. Not calculating next index range, not updating ranges.");
                    sw.stop();
                    return;
                }
                try {
                    IndexRange indexRange = this.indexRangeService.calculateRange(index);
                    this.indexRangeService.save(indexRange);
                    LOG.info("Created ranges for index {}: {}", (Object)index, (Object)indexRange);
                }
                catch (Exception e) {
                    LOG.info("Could not calculate range of index [" + index + "]. Skipping.", (Throwable)e);
                }
                finally {
                    ++this.indicesCalculated;
                }
            }
        }
        this.info("Done calculating index ranges for " + this.indicesToCalculate + " indices. Took " + sw.stop().elapsed(TimeUnit.MILLISECONDS) + "ms.");
    }

    protected void info(String what) {
        LOG.info(what);
        this.activityWriter.write(new Activity(what, RebuildIndexRangesJob.class));
    }

    @Override
    public boolean providesProgress() {
        return true;
    }

    @Override
    public boolean isCancelable() {
        return true;
    }

    @Override
    public int maxConcurrency() {
        return 1;
    }

    @Override
    public String getClassName() {
        return this.getClass().getCanonicalName();
    }

    public static interface Factory {
        public RebuildIndexRangesJob create(Set<IndexSet> var1);
    }
}

