/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.missing.Missing;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStats;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.graylog2.Configuration;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.IndexHelper;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.indexer.results.CountResult;
import org.graylog2.indexer.results.DateHistogramResult;
import org.graylog2.indexer.results.FieldHistogramResult;
import org.graylog2.indexer.results.FieldStatsResult;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.results.SearchResult;
import org.graylog2.indexer.results.TermsResult;
import org.graylog2.indexer.results.TermsStatsResult;
import org.graylog2.indexer.searches.SearchesConfig;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.indexer.searches.timeranges.TimeRanges;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Searches {
    private static final Logger LOG = LoggerFactory.getLogger(Searches.class);
    public static final String AGG_TERMS = "gl2_terms";
    public static final String AGG_STATS = "gl2_stats";
    public static final String AGG_TERMS_STATS = "gl2_termsstats";
    public static final String AGG_FILTER = "gl2_filter";
    public static final String AGG_HISTOGRAM = "gl2_histogram";
    public static final String AGG_EXTENDED_STATS = "gl2_extended_stats";
    public static final String AGG_CARDINALITY = "gl2_field_cardinality";
    public static final String AGG_VALUE_COUNT = "gl2_value_count";
    private static final Pattern filterStreamIdPattern = Pattern.compile("^(.+[^\\p{Alnum}])?streams:([\\p{XDigit}]+)");
    private final Configuration configuration;
    private final IndexRangeService indexRangeService;
    private final Client c;
    private final Timer esRequestTimer;
    private final Histogram esTimeRangeHistogram;
    private final StreamService streamService;
    private final Indices indices;

    @Inject
    public Searches(Configuration configuration, IndexRangeService indexRangeService, Client client, MetricRegistry metricRegistry, StreamService streamService, Indices indices) {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.indexRangeService = (IndexRangeService)Preconditions.checkNotNull((Object)indexRangeService);
        this.c = (Client)Preconditions.checkNotNull((Object)client);
        this.esRequestTimer = metricRegistry.timer(MetricRegistry.name(Searches.class, (String[])new String[]{"elasticsearch", "requests"}));
        this.esTimeRangeHistogram = metricRegistry.histogram(MetricRegistry.name(Searches.class, (String[])new String[]{"elasticsearch", "ranges"}));
        this.streamService = streamService;
        this.indices = indices;
    }

    public CountResult count(String query, TimeRange range) {
        return this.count(query, range, null);
    }

    public CountResult count(String query, TimeRange range, String filter) {
        Set<String> indices = this.determineAffectedIndices(range, filter);
        SearchRequestBuilder srb = filter == null ? this.standardSearchRequest(query, indices, range) : this.filteredSearchRequest(query, filter, indices, range);
        srb.setSize(0);
        SearchResponse r = (SearchResponse)this.c.search(srb.request()).actionGet();
        this.recordEsMetrics(r, range);
        return CountResult.create(r.getHits().getTotalHits(), r.getTookInMillis());
    }

    public ScrollResult scroll(String query, TimeRange range, int limit, int offset, List<String> fields, String filter) {
        Set<String> indices = this.determineAffectedIndices(range, filter);
        SearchRequest request = this.standardSearchRequest(query, indices, limit, offset, range, filter, null, false).setScroll(new TimeValue(1L, TimeUnit.MINUTES)).setSize(500).addSort((SortBuilder)SortBuilders.fieldSort((String)"_doc")).addFields(fields.toArray(new String[fields.size()])).addField("_source").request();
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("ElasticSearch scroll query: {}", (Object)XContentHelper.convertToJson((BytesReference)request.source(), (boolean)false));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        SearchResponse r = (SearchResponse)this.c.search(request).actionGet();
        this.recordEsMetrics(r, range);
        return new ScrollResult(this.c, query, request.source(), r, fields);
    }

    public SearchResult search(String query, TimeRange range, int limit, int offset, Sorting sorting) {
        return this.search(query, null, range, limit, offset, sorting);
    }

    public SearchResult search(String query, String filter, TimeRange range, int limit, int offset, Sorting sorting) {
        SearchesConfig searchesConfig = SearchesConfig.builder().query(query).filter(filter).range(range).limit(limit).offset(offset).sorting(sorting).build();
        return this.search(searchesConfig);
    }

    public SearchResult search(SearchesConfig config) {
        Set<IndexRange> indices = this.determineAffectedIndicesWithRanges(config.range(), config.filter());
        HashSet indexNames = Sets.newHashSet();
        for (IndexRange index : indices) {
            indexNames.add(index.indexName());
        }
        SearchRequest request = this.searchRequest(config, indexNames).request();
        SearchResponse r = (SearchResponse)this.c.search(request).actionGet();
        this.recordEsMetrics(r, config.range());
        return new SearchResult(r.getHits(), indices, config.query(), request.source(), r.getTook());
    }

    public TermsResult terms(String field, int size, String query, String filter, TimeRange range) {
        if (size == 0) {
            size = 50;
        }
        SearchRequestBuilder srb = filter == null ? this.standardSearchRequest(query, this.determineAffectedIndices(range, null), range) : this.filteredSearchRequest(query, filter, this.determineAffectedIndices(range, filter), range);
        FilterAggregationBuilder builder = ((FilterAggregationBuilder)((FilterAggregationBuilder)AggregationBuilders.filter((String)AGG_FILTER).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)AGG_TERMS).field(field)).size(size))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.missing((String)"missing").field(field))).filter(this.standardAggregationFilters(range, filter));
        srb.addAggregation((AbstractAggregationBuilder)builder);
        SearchRequest request = srb.request();
        SearchResponse r = (SearchResponse)this.c.search(request).actionGet();
        this.recordEsMetrics(r, range);
        Filter f = (Filter)r.getAggregations().get(AGG_FILTER);
        return new TermsResult((Terms)f.getAggregations().get(AGG_TERMS), (Missing)f.getAggregations().get("missing"), f.getDocCount(), query, request.source(), r.getTook());
    }

    public TermsResult terms(String field, int size, String query, TimeRange range) {
        return this.terms(field, size, query, null, range);
    }

    public TermsStatsResult termsStats(String keyField, String valueField, TermsStatsOrder order, int size, String query, String filter, TimeRange range) {
        Terms.Order termsOrder;
        if (size == 0) {
            size = 50;
        }
        SearchRequestBuilder srb = filter == null ? this.standardSearchRequest(query, this.determineAffectedIndices(range, filter), range) : this.filteredSearchRequest(query, filter, this.determineAffectedIndices(range, filter), range);
        switch (order) {
            case COUNT: {
                termsOrder = Terms.Order.count((boolean)true);
                break;
            }
            case REVERSE_COUNT: {
                termsOrder = Terms.Order.count((boolean)false);
                break;
            }
            case TERM: {
                termsOrder = Terms.Order.term((boolean)true);
                break;
            }
            case REVERSE_TERM: {
                termsOrder = Terms.Order.term((boolean)false);
                break;
            }
            case MIN: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"min", (boolean)true);
                break;
            }
            case REVERSE_MIN: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"min", (boolean)false);
                break;
            }
            case MAX: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"max", (boolean)true);
                break;
            }
            case REVERSE_MAX: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"max", (boolean)false);
                break;
            }
            case MEAN: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"avg", (boolean)true);
                break;
            }
            case REVERSE_MEAN: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"avg", (boolean)false);
                break;
            }
            case TOTAL: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"sum", (boolean)true);
                break;
            }
            case REVERSE_TOTAL: {
                termsOrder = Terms.Order.aggregation((String)AGG_STATS, (String)"sum", (boolean)false);
                break;
            }
            default: {
                termsOrder = Terms.Order.count((boolean)true);
            }
        }
        FilterAggregationBuilder builder = ((FilterAggregationBuilder)AggregationBuilders.filter((String)AGG_FILTER).subAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)AGG_TERMS_STATS).field(keyField)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.stats((String)AGG_STATS).field(valueField))).order(termsOrder).size(size))).filter(this.standardAggregationFilters(range, filter));
        srb.addAggregation((AbstractAggregationBuilder)builder);
        SearchRequest request = srb.request();
        SearchResponse r = (SearchResponse)this.c.search(request).actionGet();
        this.recordEsMetrics(r, range);
        Filter f = (Filter)r.getAggregations().get(AGG_FILTER);
        return new TermsStatsResult((Terms)f.getAggregations().get(AGG_TERMS_STATS), query, request.source(), r.getTook());
    }

    public TermsStatsResult termsStats(String keyField, String valueField, TermsStatsOrder order, int size, String query, TimeRange range) {
        return this.termsStats(keyField, valueField, order, size, query, null, range);
    }

    public FieldStatsResult fieldStats(String field, String query, TimeRange range) throws FieldTypeException {
        return this.fieldStats(field, query, null, range);
    }

    public FieldStatsResult fieldStats(String field, String query, String filter, TimeRange range) throws FieldTypeException {
        return this.fieldStats(field, query, filter, range, true, true, true);
    }

    public FieldStatsResult fieldStats(String field, String query, String filter, TimeRange range, boolean includeCardinality, boolean includeStats, boolean includeCount) throws FieldTypeException {
        SearchResponse r;
        SearchRequest request;
        Set<String> indices = this.indicesContainingField(this.determineAffectedIndices(range, filter), field);
        SearchRequestBuilder srb = filter == null ? this.standardSearchRequest(query, indices, range) : this.filteredSearchRequest(query, filter, indices, range);
        FilterAggregationBuilder builder = AggregationBuilders.filter((String)AGG_FILTER).filter(this.standardAggregationFilters(range, filter));
        if (includeCount) {
            builder.subAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)AGG_VALUE_COUNT).field(field));
        }
        if (includeStats) {
            builder.subAggregation((AbstractAggregationBuilder)AggregationBuilders.extendedStats((String)AGG_EXTENDED_STATS).field(field));
        }
        if (includeCardinality) {
            builder.subAggregation((AbstractAggregationBuilder)AggregationBuilders.cardinality((String)AGG_CARDINALITY).field(field));
        }
        srb.addAggregation((AbstractAggregationBuilder)builder);
        try {
            request = srb.request();
            r = (SearchResponse)this.c.search(request).actionGet();
        }
        catch (SearchPhaseExecutionException e) {
            throw new FieldTypeException(e);
        }
        this.checkForFailedShards(r);
        this.recordEsMetrics(r, range);
        Filter f = (Filter)r.getAggregations().get(AGG_FILTER);
        return new FieldStatsResult((ValueCount)f.getAggregations().get(AGG_VALUE_COUNT), (ExtendedStats)f.getAggregations().get(AGG_EXTENDED_STATS), (Cardinality)f.getAggregations().get(AGG_CARDINALITY), r.getHits(), query, request.source(), r.getTook());
    }

    private Set<String> indicesContainingField(Set<String> strings, String field) {
        return this.indices.getAllMessageFieldsForIndices(strings.toArray(new String[strings.size()])).entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(field)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public HistogramResult histogram(String query, DateHistogramInterval interval, TimeRange range) {
        return this.histogram(query, interval, null, range);
    }

    public HistogramResult histogram(String query, DateHistogramInterval interval, String filter, TimeRange range) {
        FilterAggregationBuilder builder = ((FilterAggregationBuilder)AggregationBuilders.filter((String)AGG_FILTER).subAggregation((AbstractAggregationBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)AGG_HISTOGRAM).field("timestamp")).interval(interval.toESInterval()))).filter(this.standardAggregationFilters(range, filter));
        QueryStringQueryBuilder qs = QueryBuilders.queryStringQuery((String)query);
        qs.allowLeadingWildcard(this.configuration.isAllowLeadingWildcardSearches());
        Set<String> affectedIndices = this.determineAffectedIndices(range, filter);
        SearchRequestBuilder srb = this.c.prepareSearch(affectedIndices.toArray(new String[affectedIndices.size()])).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)qs).addAggregation((AbstractAggregationBuilder)builder);
        SearchRequest request = srb.request();
        SearchResponse r = (SearchResponse)this.c.search(request).actionGet();
        this.recordEsMetrics(r, range);
        Filter f = (Filter)r.getAggregations().get(AGG_FILTER);
        return new DateHistogramResult((org.elasticsearch.search.aggregations.bucket.histogram.Histogram)f.getAggregations().get(AGG_HISTOGRAM), query, request.source(), interval, r.getTook());
    }

    public HistogramResult fieldHistogram(String query, String field, DateHistogramInterval interval, String filter, TimeRange range, boolean includeCardinality) throws FieldTypeException {
        SearchResponse r;
        DateHistogramBuilder dateHistogramBuilder = ((DateHistogramBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)AGG_HISTOGRAM).field("timestamp")).subAggregation((AbstractAggregationBuilder)AggregationBuilders.stats((String)AGG_STATS).field(field))).interval(interval.toESInterval());
        if (includeCardinality) {
            dateHistogramBuilder.subAggregation((AbstractAggregationBuilder)AggregationBuilders.cardinality((String)AGG_CARDINALITY).field(field));
        }
        FilterAggregationBuilder builder = ((FilterAggregationBuilder)AggregationBuilders.filter((String)AGG_FILTER).subAggregation((AbstractAggregationBuilder)dateHistogramBuilder)).filter(this.standardAggregationFilters(range, filter));
        QueryStringQueryBuilder qs = QueryBuilders.queryStringQuery((String)query);
        qs.allowLeadingWildcard(this.configuration.isAllowLeadingWildcardSearches());
        SearchRequestBuilder srb = this.c.prepareSearch(new String[0]);
        Set<String> affectedIndices = this.determineAffectedIndices(range, filter);
        srb.setIndices(affectedIndices.toArray(new String[affectedIndices.size()]));
        srb.setQuery((QueryBuilder)qs);
        srb.addAggregation((AbstractAggregationBuilder)builder);
        SearchRequest request = srb.request();
        try {
            r = (SearchResponse)this.c.search(request).actionGet();
        }
        catch (SearchPhaseExecutionException e) {
            throw new FieldTypeException(e);
        }
        this.checkForFailedShards(r);
        this.recordEsMetrics(r, range);
        Filter f = (Filter)r.getAggregations().get(AGG_FILTER);
        return new FieldHistogramResult((org.elasticsearch.search.aggregations.bucket.histogram.Histogram)f.getAggregations().get(AGG_HISTOGRAM), query, request.source(), interval, r.getTook());
    }

    private void checkForFailedShards(SearchResponse r) throws FieldTypeException {
        Optional<ShardSearchFailure> failure;
        if (r.getFailedShards() > 0 && (failure = Arrays.stream(r.getShardFailures()).filter(shardSearchFailure -> shardSearchFailure.getCause() instanceof IllegalArgumentException).findFirst()).isPresent()) {
            throw new FieldTypeException(failure.get().getCause());
        }
    }

    private SearchRequestBuilder searchRequest(SearchesConfig config, Set<String> indices) {
        SearchRequestBuilder request = config.filter() == null ? this.standardSearchRequest(config.query(), indices, config.limit(), config.offset(), config.range(), config.sorting()) : this.filteredSearchRequest(config.query(), config.filter(), indices, config.limit(), config.offset(), config.range(), config.sorting());
        if (config.fields() != null) {
            request.addFields(config.fields().toArray(new String[config.fields().size()]));
        }
        return request;
    }

    private SearchRequestBuilder standardSearchRequest(String query, Set<String> indices, TimeRange range) {
        return this.standardSearchRequest(query, indices, 0, 0, range, null);
    }

    private SearchRequestBuilder standardSearchRequest(String query, Set<String> indices, int limit, int offset, TimeRange range, Sorting sort) {
        return this.standardSearchRequest(query, indices, limit, offset, range, sort, true);
    }

    private SearchRequestBuilder standardSearchRequest(String query, Set<String> indices, int limit, int offset, TimeRange range, Sorting sort, boolean highlight) {
        return this.standardSearchRequest(query, indices, limit, offset, range, null, sort, highlight);
    }

    private SearchRequestBuilder standardSearchRequest(String query, Set<String> indices, int limit, int offset, TimeRange range, String filter, Sorting sort, boolean highlight) {
        if (query == null || query.trim().isEmpty()) {
            query = "*";
        }
        Object queryBuilder = query.trim().equals("*") ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery((String)query).allowLeadingWildcard(this.configuration.isAllowLeadingWildcardSearches());
        SearchRequestBuilder srb = this.c.prepareSearch(indices.toArray(new String[indices.size()])).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).filter(this.standardFilters(range, filter))).setFrom(offset);
        if (limit > 0) {
            srb.setSize(limit);
        }
        if (sort != null) {
            srb.addSort(sort.getField(), sort.asElastic());
        }
        if (highlight && this.configuration.isAllowHighlighting()) {
            srb.setHighlighterRequireFieldMatch(false);
            srb.addHighlightedField("*", 0, 0);
        }
        return srb;
    }

    private SearchRequestBuilder filteredSearchRequest(String query, String filter, Set<String> indices, TimeRange range) {
        return this.filteredSearchRequest(query, filter, indices, 0, 0, range, null);
    }

    private SearchRequestBuilder filteredSearchRequest(String query, String filter, Set<String> indices, int limit, int offset, TimeRange range, Sorting sort) {
        return this.standardSearchRequest(query, indices, limit, offset, range, filter, sort, true);
    }

    private void recordEsMetrics(SearchResponse r, @Nullable TimeRange range) {
        this.esRequestTimer.update(r.getTookInMillis(), TimeUnit.MILLISECONDS);
        if (range != null) {
            this.esTimeRangeHistogram.update(TimeRanges.toSeconds(range));
        }
    }

    @Nullable
    private QueryBuilder standardFilters(TimeRange range, String filter) {
        BoolQueryBuilder bfb = null;
        if (range != null) {
            bfb = QueryBuilders.boolQuery();
            bfb.must(IndexHelper.getTimestampRangeFilter(range));
        }
        if (!Strings.isNullOrEmpty((String)filter) && !filter.equals("*")) {
            if (bfb == null) {
                bfb = QueryBuilders.boolQuery();
            }
            bfb.must((QueryBuilder)QueryBuilders.queryStringQuery((String)filter));
        }
        return bfb;
    }

    private QueryBuilder standardAggregationFilters(TimeRange range, String filter) {
        QueryBuilder filterBuilder = this.standardFilters(range, filter);
        if (filterBuilder == null) {
            throw new RuntimeException("Either range or filter must be set.");
        }
        return filterBuilder;
    }

    public static Optional<String> extractStreamId(String filter) {
        if (joptsimple.internal.Strings.isNullOrEmpty((String)filter)) {
            return Optional.empty();
        }
        Matcher streamIdMatcher = filterStreamIdPattern.matcher(filter);
        if (streamIdMatcher.find()) {
            return Optional.of(streamIdMatcher.group(2));
        }
        return Optional.empty();
    }

    public Set<String> determineAffectedIndices(TimeRange range, @Nullable String filter) {
        Set<IndexRange> indexRanges = this.determineAffectedIndicesWithRanges(range, filter);
        return indexRanges.stream().map(IndexRange::indexName).collect(Collectors.toSet());
    }

    public Set<IndexRange> determineAffectedIndicesWithRanges(TimeRange range, @Nullable String filter) {
        Optional<String> streamId = Searches.extractStreamId(filter);
        IndexSet indexSet = null;
        if (streamId.isPresent()) {
            try {
                Stream stream = this.streamService.load(streamId.get());
                indexSet = stream.getIndexSet();
            }
            catch (NotFoundException stream) {
                // empty catch block
            }
        }
        ImmutableSortedSet.Builder indices = ImmutableSortedSet.orderedBy(IndexRange.COMPARATOR);
        SortedSet<IndexRange> indexRanges = this.indexRangeService.find(range.getFrom(), range.getTo());
        for (IndexRange indexRange : indexRanges) {
            boolean streamInCurrentIndexSet;
            if (indexSet == null && filter == null) {
                indices.add((Object)indexRange);
                continue;
            }
            boolean streamInIndexRange = streamId.isPresent() && indexRange.streamIds() != null && indexRange.streamIds().contains(streamId.get());
            boolean bl = streamInCurrentIndexSet = indexSet != null && indexSet.isManagedIndex(indexRange.indexName());
            if (streamInIndexRange) {
                indices.add((Object)indexRange);
            }
            if (!streamInCurrentIndexSet) continue;
            indices.add((Object)indexRange);
        }
        return indices.build();
    }

    public static class FieldTypeException
    extends Exception {
        public FieldTypeException(Throwable e) {
            super(e);
        }
    }

    public static enum DateHistogramInterval {
        YEAR(Period.years((int)1)),
        QUARTER(Period.months((int)3)),
        MONTH(Period.months((int)1)),
        WEEK(Period.weeks((int)1)),
        DAY(Period.days((int)1)),
        HOUR(Period.hours((int)1)),
        MINUTE(Period.minutes((int)1));

        private final Period period;

        private DateHistogramInterval(Period period) {
            this.period = period;
        }

        public Period getPeriod() {
            return this.period;
        }

        public org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval toESInterval() {
            switch (this.name()) {
                case "MINUTE": {
                    return org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval.MINUTE;
                }
                case "HOUR": {
                    return org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval.HOUR;
                }
                case "DAY": {
                    return org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval.DAY;
                }
                case "WEEK": {
                    return org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval.WEEK;
                }
                case "MONTH": {
                    return org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval.MONTH;
                }
                case "QUARTER": {
                    return org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval.QUARTER;
                }
            }
            return org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval.YEAR;
        }
    }

    public static enum TermsStatsOrder {
        TERM,
        REVERSE_TERM,
        COUNT,
        REVERSE_COUNT,
        TOTAL,
        REVERSE_TOTAL,
        MIN,
        REVERSE_MIN,
        MAX,
        REVERSE_MAX,
        MEAN,
        REVERSE_MEAN;

    }
}

