/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import javax.inject.Inject;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationImpl;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmCallbacksMigrationPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmCallbacksMigrationPeriodical.class);
    private final DBCollection dbCollection;

    @Inject
    public AlarmCallbacksMigrationPeriodical(MongoConnection mongoConnection) {
        String collectionName = AlarmCallbackConfigurationImpl.class.getAnnotation(CollectionName.class).value();
        this.dbCollection = mongoConnection.getDatabase().getCollection(collectionName);
    }

    @Override
    public void doRun() {
        LOG.debug("Starting alarm callbacks migration");
        DBObject selection = QueryBuilder.start((String)"id").exists((Object)true).get();
        BasicDBObject modifications = new BasicDBObject("$unset", (Object)new BasicDBObject("id", (Object)""));
        this.dbCollection.updateMulti(selection, (DBObject)modifications);
        LOG.debug("Done with alarm callbacks migration");
    }

    @Override
    public boolean runsForever() {
        return true;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

