/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.count;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.counts.Counts;
import org.graylog2.rest.models.count.responses.MessageCountResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Counts", description="Message counts")
@Path(value="/count")
public class CountResource
extends RestResource {
    private final Counts counts;
    private final IndexSetRegistry indexSetRegistry;

    @Inject
    public CountResource(Counts counts, IndexSetRegistry indexSetRegistry) {
        this.counts = counts;
        this.indexSetRegistry = indexSetRegistry;
    }

    @GET
    @Path(value="/total")
    @Timed
    @RequiresPermissions(value={"messagecount:read"})
    @ApiOperation(value="Total number of messages in all your indices.")
    @Produces(value={"application/json"})
    public MessageCountResponse total() {
        return MessageCountResponse.create(this.counts.total());
    }

    @GET
    @Path(value="/{indexSetId}/total")
    @Timed
    @RequiresPermissions(value={"messagecount:read"})
    @ApiOperation(value="Total number of messages in all your indices.")
    @Produces(value={"application/json"})
    public MessageCountResponse total(@ApiParam(name="indexSetId") @PathParam(value="indexSetId") String indexSetId) {
        IndexSet indexSet = this.getIndexSet(this.indexSetRegistry, indexSetId);
        return MessageCountResponse.create(this.counts.total(indexSet));
    }
}

