/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.buffers;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.lmax.disruptor.WorkHandler;
import javax.inject.Inject;
import org.graylog2.shared.buffers.RawMessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawMessageEncoderHandler
implements WorkHandler<RawMessageEvent> {
    private static final Logger log = LoggerFactory.getLogger(RawMessageEncoderHandler.class);
    private final Meter incomingMessages;

    @Inject
    public RawMessageEncoderHandler(MetricRegistry metricRegistry) {
        this.incomingMessages = metricRegistry.meter(MetricRegistry.name(RawMessageEncoderHandler.class, (String[])new String[]{"incomingMessages"}));
    }

    public void onEvent(RawMessageEvent event) throws Exception {
        this.incomingMessages.mark();
        event.setEncodedRawMessage(event.getRawMessage().encode());
        event.setMessageIdBytes(event.getRawMessage().getIdBytes());
        if (log.isTraceEnabled()) {
            log.trace("Serialized message {} for journal, size {} bytes", (Object)event.getRawMessage().getId(), (Object)event.getEncodedRawMessage().length);
        }
        event.setRawMessage(null);
    }
}

