/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2;

import com.google.common.collect.Sets;
import com.mongodb.BasicDBList;
import java.util.HashSet;
import java.util.Set;
import org.graylog2.SystemSetting;
import org.graylog2.database.MongoConnection;

public class SystemSettingAccessor {
    private final MongoConnection mongoConnection;
    private static final String KEY_ALLOW_USAGE_STATS = "allow_usage_stats";
    private static final String KEY_FORCED_ALARM_CALLBACKS = "forced_alarm_callbacks";

    public SystemSettingAccessor(MongoConnection mongoConnection) {
        this.mongoConnection = mongoConnection;
    }

    public boolean allowUsageStats() {
        SystemSetting s = new SystemSetting(this.mongoConnection);
        return s.getBoolean(KEY_ALLOW_USAGE_STATS);
    }

    public Set<String> getForcedAlarmCallbacks() {
        HashSet callbacks = Sets.newHashSet();
        SystemSetting s = new SystemSetting(this.mongoConnection);
        BasicDBList objs = s.getList(KEY_FORCED_ALARM_CALLBACKS);
        for (Object obj : objs) {
            String typeclass = (String)obj;
            if (typeclass == null || typeclass.isEmpty()) continue;
            callbacks.add(typeclass);
        }
        return callbacks;
    }
}

