/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import java.util.Optional;
import javax.inject.Inject;
import org.graylog2.indexer.AutoValue_IndexSetValidator_Violation;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.indexset.IndexSetConfig;

public class IndexSetValidator {
    private final IndexSetRegistry indexSetRegistry;

    @Inject
    public IndexSetValidator(IndexSetRegistry indexSetRegistry) {
        this.indexSetRegistry = indexSetRegistry;
    }

    public Optional<Violation> validate(IndexSetConfig newConfig) {
        String indexName = newConfig.indexPrefix() + "_" + "0";
        if (this.indexSetRegistry.isManagedIndex(indexName)) {
            return Optional.of(Violation.create("Index prefix \"" + newConfig.indexPrefix() + "\" would conflict with an existing index set!"));
        }
        for (IndexSet indexSet : this.indexSetRegistry) {
            if (!newConfig.indexPrefix().startsWith(indexSet.getIndexPrefix()) && !indexSet.getIndexPrefix().startsWith(newConfig.indexPrefix())) continue;
            return Optional.of(Violation.create("Index prefix \"" + newConfig.indexPrefix() + "\" would conflict with existing index set prefix \"" + indexSet.getIndexPrefix() + "\""));
        }
        return Optional.empty();
    }

    public static abstract class Violation {
        public abstract String message();

        public static Violation create(String message) {
            return new AutoValue_IndexSetValidator_Violation(message);
        }
    }
}

