/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;
import org.joda.time.DateTime;

public class DateHistogramResult
extends HistogramResult {
    private final Histogram result;
    private final Searches.DateHistogramInterval interval;

    public DateHistogramResult(Histogram result, String originalQuery, BytesReference builtQuery, Searches.DateHistogramInterval interval, TimeValue took) {
        super(originalQuery, builtQuery, took);
        this.result = result;
        this.interval = interval;
    }

    @Override
    public Searches.DateHistogramInterval getInterval() {
        return this.interval;
    }

    @Override
    public Map<Long, Long> getResults() {
        TreeMap results = Maps.newTreeMap();
        for (Histogram.Bucket bucket : this.result.getBuckets()) {
            DateTime keyAsDate = (DateTime)bucket.getKey();
            results.put(keyAsDate.getMillis() / 1000L, bucket.getDocCount());
        }
        return results;
    }
}

