/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.stats.Stats;
import org.graylog2.indexer.results.IndexQueryResult;

public class TermsStatsResult
extends IndexQueryResult {
    private static final Comparator<Map<String, Object>> COMPARATOR = new Comparator<Map<String, Object>>(){

        @Override
        public int compare(Map<String, Object> o1, Map<String, Object> o2) {
            double o2Mean;
            double o1Mean = (Double)o1.get("mean");
            if (o1Mean > (o2Mean = ((Double)o2.get("mean")).doubleValue())) {
                return -1;
            }
            if (o1Mean < o2Mean) {
                return 1;
            }
            return 0;
        }
    };
    private final Terms facet;

    public TermsStatsResult(Terms facet, String originalQuery, BytesReference builtQuery, TimeValue took) {
        super(originalQuery, builtQuery, took);
        this.facet = facet;
    }

    public List<Map<String, Object>> getResults() {
        ArrayList results = Lists.newArrayList();
        for (Terms.Bucket e : this.facet.getBuckets()) {
            HashMap resultMap = Maps.newHashMap();
            resultMap.put("key_field", e.getKey());
            resultMap.put("count", e.getDocCount());
            Stats stats = (Stats)e.getAggregations().get("gl2_stats");
            resultMap.put("min", stats.getMin());
            resultMap.put("max", stats.getMax());
            resultMap.put("total", stats.getSum());
            resultMap.put("total_count", stats.getCount());
            resultMap.put("mean", stats.getAvg());
            results.add(resultMap);
        }
        Collections.sort(results, COMPARATOR);
        return results;
    }
}

