/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.github.joschi.jadconfig.validators.StringNotBlankValidator;
import com.github.joschi.jadconfig.validators.URIAbsoluteValidator;
import com.google.common.annotations.VisibleForTesting;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.graylog2.plugin.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(BaseConfiguration.class);
    protected static final int GRAYLOG_DEFAULT_PORT = 9000;
    protected static final int GRAYLOG_DEFAULT_WEB_PORT = 9000;
    @Parameter(value="shutdown_timeout", validator=PositiveIntegerValidator.class)
    protected int shutdownTimeout = 30000;
    @Parameter(value="rest_transport_uri", validator=URIAbsoluteValidator.class)
    private URI restTransportUri;
    @Parameter(value="processbuffer_processors", required=true, validator=PositiveIntegerValidator.class)
    private int processBufferProcessors = 5;
    @Parameter(value="processor_wait_strategy", required=true)
    private String processorWaitStrategy = "blocking";
    @Parameter(value="ring_size", required=true, validator=PositiveIntegerValidator.class)
    private int ringSize = 65536;
    @Parameter(value="inputbuffer_ring_size", required=true, validator=PositiveIntegerValidator.class)
    private int inputBufferRingSize = 65536;
    @Parameter(value="inputbuffer_wait_strategy", required=true)
    private String inputBufferWaitStrategy = "blocking";
    @Parameter(value="rest_enable_cors")
    private boolean restEnableCors = true;
    @Parameter(value="rest_enable_gzip")
    private boolean restEnableGzip = true;
    @Parameter(value="rest_max_initial_line_length", required=true, validator=PositiveIntegerValidator.class)
    private int restMaxInitialLineLength = 4096;
    @Parameter(value="rest_max_header_size", required=true, validator=PositiveIntegerValidator.class)
    private int restMaxHeaderSize = 8192;
    @Parameter(value="rest_thread_pool_size", required=true, validator=PositiveIntegerValidator.class)
    private int restThreadPoolSize = 16;
    @Parameter(value="rest_selector_runners_count", required=true, validator=PositiveIntegerValidator.class)
    private int restSelectorRunnersCount = 1;
    @Parameter(value="rest_enable_tls")
    private boolean restEnableTls = false;
    @Parameter(value="rest_tls_cert_file")
    private Path restTlsCertFile;
    @Parameter(value="rest_tls_key_file")
    private Path restTlsKeyFile;
    @Parameter(value="rest_tls_key_password")
    private String restTlsKeyPassword;
    @Parameter(value="plugin_dir")
    private String pluginDir = "plugin";
    @Parameter(value="async_eventbus_processors")
    private int asyncEventbusProcessors = 2;
    @Parameter(value="udp_recvbuffer_sizes", required=true, validator=PositiveIntegerValidator.class)
    private int udpRecvBufferSizes = 0x100000;
    @Parameter(value="message_journal_enabled")
    private boolean messageJournalEnabled = true;
    @Parameter(value="inputbuffer_processors")
    private int inputbufferProcessors = 2;
    @Parameter(value="message_recordings_enable")
    private boolean messageRecordingsEnable = false;
    @Parameter(value="disable_sigar")
    private boolean disableSigar = false;
    @Parameter(value="http_proxy_uri")
    private URI httpProxyUri;
    @Parameter(value="http_connect_timeout", validator=PositiveDurationValidator.class)
    private Duration httpConnectTimeout = Duration.seconds((long)5L);
    @Parameter(value="http_write_timeout", validator=PositiveDurationValidator.class)
    private Duration httpWriteTimeout = Duration.seconds((long)10L);
    @Parameter(value="http_read_timeout", validator=PositiveDurationValidator.class)
    private Duration httpReadTimeout = Duration.seconds((long)10L);
    @Parameter(value="installation_source", validator=StringNotBlankValidator.class)
    private String installationSource = "unknown";
    @Parameter(value="web_enable")
    private boolean webEnable = true;
    @Parameter(value="web_endpoint_uri")
    private URI webEndpointUri;
    @Parameter(value="web_enable_cors")
    private boolean webEnableCors = false;
    @Parameter(value="web_enable_gzip")
    private boolean webEnableGzip = true;
    @Parameter(value="web_max_initial_line_length", required=true, validator=PositiveIntegerValidator.class)
    private int webMaxInitialLineLength = 4096;
    @Parameter(value="web_max_header_size", required=true, validator=PositiveIntegerValidator.class)
    private int webMaxHeaderSize = 8192;
    @Parameter(value="web_enable_tls")
    private boolean webEnableTls = false;
    @Parameter(value="web_thread_pool_size", required=true, validator=PositiveIntegerValidator.class)
    private int webThreadPoolSize = 16;
    @Parameter(value="web_selector_runners_count", required=true, validator=PositiveIntegerValidator.class)
    private int webSelectorRunnersCount = 1;
    @Parameter(value="web_tls_cert_file")
    private Path webTlsCertFile;
    @Parameter(value="web_tls_key_file")
    private Path webTlsKeyFile;
    @Parameter(value="web_tls_key_password")
    private String webTlsKeyPassword;
    @Parameter(value="proxied_requests_thread_pool_size", required=true, validator=PositiveIntegerValidator.class)
    private int proxiedRequestsThreadPoolSize = 32;

    public String getRestUriScheme() {
        return this.getUriScheme(this.isRestEnableTls());
    }

    public String getWebUriScheme() {
        return this.getUriScheme(this.isWebEnableTls());
    }

    public String getUriScheme(boolean enableTls) {
        return enableTls ? "https" : "http";
    }

    public URI getRestTransportUri() {
        if (this.restTransportUri == null) {
            LOG.debug("No rest_transport_uri set. Using default [{}].", (Object)this.getDefaultRestTransportUri());
            return this.getDefaultRestTransportUri();
        }
        if ("0.0.0.0".equals(this.restTransportUri.getHost())) {
            LOG.warn("\"{}\" is not a valid setting for \"rest_transport_uri\". Using default [{}].", (Object)this.restTransportUri, (Object)this.getDefaultRestTransportUri());
            return this.getDefaultRestTransportUri();
        }
        return Tools.normalizeURI(this.restTransportUri, this.restTransportUri.getScheme(), 9000, "/");
    }

    public void setRestTransportUri(URI restTransportUri) {
        this.restTransportUri = restTransportUri;
    }

    @VisibleForTesting
    protected URI getDefaultRestTransportUri() {
        URI transportUri;
        URI listenUri = this.getRestListenUri();
        if ("0.0.0.0".equals(listenUri.getHost())) {
            InetAddress guessedAddress;
            try {
                guessedAddress = Tools.guessPrimaryNetworkAddress();
                if (guessedAddress.isLoopbackAddress()) {
                    LOG.debug("Using loopback address {}", (Object)guessedAddress);
                }
            }
            catch (Exception e) {
                LOG.error("Could not guess primary network address for \"rest_transport_uri\". Please configure it in your Graylog configuration.", (Throwable)e);
                throw new RuntimeException("No rest_transport_uri.", e);
            }
            try {
                transportUri = new URI(listenUri.getScheme(), listenUri.getUserInfo(), guessedAddress.getHostAddress(), listenUri.getPort(), listenUri.getPath(), listenUri.getQuery(), listenUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid rest_transport_uri.", e);
            }
        }
        transportUri = listenUri;
        return transportUri;
    }

    public int getProcessBufferProcessors() {
        return this.processBufferProcessors;
    }

    private WaitStrategy getWaitStrategy(String waitStrategyName, String configOptionName) {
        switch (waitStrategyName) {
            case "sleeping": {
                return new SleepingWaitStrategy();
            }
            case "yielding": {
                return new YieldingWaitStrategy();
            }
            case "blocking": {
                return new BlockingWaitStrategy();
            }
            case "busy_spinning": {
                return new BusySpinWaitStrategy();
            }
        }
        LOG.warn("Invalid setting for [{}]: Falling back to default: BlockingWaitStrategy.", (Object)configOptionName);
        return new BlockingWaitStrategy();
    }

    public WaitStrategy getProcessorWaitStrategy() {
        return this.getWaitStrategy(this.processorWaitStrategy, "processbuffer_wait_strategy");
    }

    public int getRingSize() {
        return this.ringSize;
    }

    public int getInputBufferRingSize() {
        return this.inputBufferRingSize;
    }

    public WaitStrategy getInputBufferWaitStrategy() {
        return this.getWaitStrategy(this.inputBufferWaitStrategy, "inputbuffer_wait_strategy");
    }

    public boolean isRestEnableCors() {
        return this.restEnableCors;
    }

    public boolean isRestEnableGzip() {
        return this.restEnableGzip;
    }

    public int getRestMaxInitialLineLength() {
        return this.restMaxInitialLineLength;
    }

    public int getRestMaxHeaderSize() {
        return this.restMaxHeaderSize;
    }

    public int getRestThreadPoolSize() {
        return this.restThreadPoolSize;
    }

    public int getRestSelectorRunnersCount() {
        return this.restSelectorRunnersCount;
    }

    public boolean isRestEnableTls() {
        return this.restEnableTls;
    }

    public Path getRestTlsCertFile() {
        return this.restTlsCertFile;
    }

    public Path getRestTlsKeyFile() {
        return this.restTlsKeyFile;
    }

    public String getRestTlsKeyPassword() {
        return this.restTlsKeyPassword;
    }

    public String getPluginDir() {
        return this.pluginDir;
    }

    public int getAsyncEventbusProcessors() {
        return this.asyncEventbusProcessors;
    }

    public abstract String getNodeIdFile();

    public abstract URI getRestListenUri();

    public abstract URI getWebListenUri();

    public boolean isMessageJournalEnabled() {
        return this.messageJournalEnabled;
    }

    public void setMessageJournalEnabled(boolean messageJournalEnabled) {
        this.messageJournalEnabled = messageJournalEnabled;
    }

    public int getInputbufferProcessors() {
        return this.inputbufferProcessors;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public int getUdpRecvBufferSizes() {
        return this.udpRecvBufferSizes;
    }

    public boolean isMessageRecordingsEnabled() {
        return this.messageRecordingsEnable;
    }

    public boolean isDisableSigar() {
        return this.disableSigar;
    }

    public URI getHttpProxyUri() {
        return this.httpProxyUri;
    }

    public Duration getHttpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    public Duration getHttpWriteTimeout() {
        return this.httpWriteTimeout;
    }

    public Duration getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public String getInstallationSource() {
        return this.installationSource;
    }

    public boolean isWebEnable() {
        return this.webEnable;
    }

    public boolean isRestAndWebOnSamePort() {
        URI restListenUri = this.getRestListenUri();
        URI webListenUri = this.getWebListenUri();
        try {
            InetAddress restAddress = InetAddress.getByName(restListenUri.getHost());
            InetAddress webAddress = InetAddress.getByName(webListenUri.getHost());
            return restListenUri.getPort() == webListenUri.getPort() && restAddress.equals(webAddress);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unable to resolve hostnames of rest/web listen uris: ", e);
        }
    }

    public boolean isWebEnableCors() {
        return this.webEnableCors;
    }

    public boolean isWebEnableGzip() {
        return this.webEnableGzip;
    }

    public int getWebMaxInitialLineLength() {
        return this.webMaxInitialLineLength;
    }

    public int getWebMaxHeaderSize() {
        return this.webMaxHeaderSize;
    }

    public boolean isWebEnableTls() {
        return this.webEnableTls;
    }

    public int getWebThreadPoolSize() {
        return this.webThreadPoolSize;
    }

    public int getWebSelectorRunnersCount() {
        return this.webSelectorRunnersCount;
    }

    public Path getWebTlsCertFile() {
        return this.webTlsCertFile;
    }

    public Path getWebTlsKeyFile() {
        return this.webTlsKeyFile;
    }

    public String getWebTlsKeyPassword() {
        return this.webTlsKeyPassword;
    }

    public URI getWebEndpointUri() {
        return this.webEndpointUri == null ? this.getRestTransportUri() : this.webEndpointUri;
    }

    public String getWebPrefix() {
        String webPrefix = this.getWebListenUri().getPath();
        if (webPrefix.endsWith("/")) {
            return webPrefix.substring(0, webPrefix.length() - 1);
        }
        return webPrefix;
    }

    @ValidatorMethod
    public void validateRestTlsConfig() throws ValidationException {
        if (this.isRestEnableTls()) {
            if (!this.isRegularFileAndReadable(this.getRestTlsKeyFile())) {
                throw new ValidationException("Unreadable or missing REST API private key: " + this.getRestTlsKeyFile());
            }
            if (!this.isRegularFileAndReadable(this.getRestTlsCertFile())) {
                throw new ValidationException("Unreadable or missing REST API X.509 certificate: " + this.getRestTlsCertFile());
            }
        }
    }

    @ValidatorMethod
    public void validateWebTlsConfig() throws ValidationException {
        if (this.isWebEnableTls() && !this.isRestAndWebOnSamePort()) {
            if (!this.isRegularFileAndReadable(this.getWebTlsKeyFile())) {
                throw new ValidationException("Unreadable or missing web interface private key: " + this.getWebTlsKeyFile());
            }
            if (!this.isRegularFileAndReadable(this.getWebTlsCertFile())) {
                throw new ValidationException("Unreadable or missing web interface X.509 certificate: " + this.getWebTlsCertFile());
            }
        }
    }

    @ValidatorMethod
    public void validateRestAndWebListenConfigConflict() throws ValidationException {
        if (this.isRestAndWebOnSamePort() && this.getRestListenUri().getPath().equals(this.getWebListenUri().getPath())) {
            throw new ValidationException("If REST and Web interface are served on the same host/port, the path must be different!");
        }
    }

    @ValidatorMethod
    public void validateWebAndRestHaveSameProtocolIfOnSamePort() throws ValidationException {
        if (this.isRestAndWebOnSamePort() && !this.getWebListenUri().getScheme().equals(this.getRestListenUri().getScheme())) {
            throw new ValidationException("If REST and Web interface are served on the same host/port, the protocols must be identical!");
        }
    }

    private boolean isRegularFileAndReadable(Path path) {
        return path != null && Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path);
    }
}

