/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.filters;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.filters.FilterService;
import org.graylog2.filters.blacklist.FilterDescription;
import org.graylog2.filters.events.FilterDescriptionUpdateEvent;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.rest.resources.RestResource;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Filters", description="Message blacklist filters")
@Path(value="/filters/blacklist")
public class BlacklistSourceResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(BlacklistSourceResource.class);
    private FilterService filterService;
    private final ClusterEventBus clusterEventBus;

    @Inject
    public BlacklistSourceResource(FilterService filterService, ClusterEventBus clusterEventBus) {
        this.filterService = filterService;
        this.clusterEventBus = clusterEventBus;
    }

    @POST
    @Timed
    @ApiOperation(value="Create a blacklist filter", notes="It can take up to a second until the change is applied")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:blacklist_filter:create")
    public Response create(@ApiParam(name="filterEntry", required=true) @Valid @NotNull FilterDescription filterDescription) throws ValidationException {
        this.checkPermission("blacklistentry:create");
        User currentUser = this.getCurrentUser();
        if (currentUser == null) {
            throw new InternalServerErrorException("Could not load user.");
        }
        filterDescription.creatorUserId = currentUser.getName();
        FilterDescription savedFilter = this.filterService.save(filterDescription);
        this.clusterEventBus.post(FilterDescriptionUpdateEvent.create(savedFilter._id.toHexString()));
        URI filterUri = this.getUriBuilderToSelf().path(BlacklistSourceResource.class).path("{filterId}").build(new Object[]{savedFilter._id});
        return Response.created((URI)filterUri).entity((Object)savedFilter).build();
    }

    @GET
    @Timed
    @ApiOperation(value="Get all blacklist filters")
    @Produces(value={"application/json"})
    public Set<FilterDescription> getAll() {
        try {
            return this.filterService.loadAll();
        }
        catch (NotFoundException e) {
            return Collections.emptySet();
        }
    }

    @GET
    @Timed
    @Path(value="/{filterId}")
    @ApiOperation(value="Get the existing blacklist filter")
    @Produces(value={"application/json"})
    public FilterDescription get(@ApiParam(name="filterId", required=true) @PathParam(value="filterId") @NotEmpty String filterId) throws NotFoundException {
        return this.filterService.load(filterId);
    }

    @PUT
    @Timed
    @Path(value="/{filterId}")
    @ApiOperation(value="Update an existing blacklist filter", notes="It can take up to a second until the change is applied")
    @Consumes(value={"application/json"})
    @AuditEvent(type="server:blacklist_filter:update")
    public void update(@ApiParam(name="filterId", required=true) @PathParam(value="filterId") String filterId, @ApiParam(name="filterEntry", required=true) FilterDescription filterEntry) throws NotFoundException, ValidationException {
        FilterDescription filter = this.filterService.load(filterId);
        if (!filter.getClass().equals(filterEntry.getClass())) {
            filterEntry._id = filter._id;
            filterEntry.createdAt = filter.createdAt;
            filterEntry.creatorUserId = filter.creatorUserId;
            filter = filterEntry;
        } else {
            filter.description = filterEntry.description;
            filter.fieldName = filterEntry.fieldName;
            filter.name = filterEntry.name;
            filter.pattern = filterEntry.pattern;
        }
        this.filterService.save(filter);
        this.clusterEventBus.post(FilterDescriptionUpdateEvent.create(filterId));
    }

    @DELETE
    @Timed
    @ApiOperation(value="Remove the existing blacklist filter", notes="It can take up to a second until the change is applied")
    @Path(value="/{filterId}")
    @AuditEvent(type="server:blacklist_filter:delete")
    public void delete(@ApiParam(name="filterId", required=true) @PathParam(value="filterId") String filterId) {
        if (this.filterService.delete(filterId) == 0) {
            throw new javax.ws.rs.NotFoundException("Couldn't find filter with ID " + filterId);
        }
        this.clusterEventBus.post(FilterDescriptionUpdateEvent.create(filterId));
    }
}

