/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.ServiceUnavailableException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.indices.TooManyAliasesException;
import org.graylog2.rest.models.system.deflector.responses.DeflectorSummary;
import org.graylog2.rest.models.system.indexer.responses.IndexRangeSummary;
import org.graylog2.rest.models.system.indexer.responses.IndexSizeSummary;
import org.graylog2.rest.models.system.indexer.responses.IndexSummary;
import org.graylog2.rest.models.system.indexer.responses.IndexerClusterOverview;
import org.graylog2.rest.models.system.indexer.responses.IndexerOverview;
import org.graylog2.rest.resources.count.CountResource;
import org.graylog2.rest.resources.system.DeflectorResource;
import org.graylog2.rest.resources.system.IndexRangesResource;
import org.graylog2.rest.resources.system.indexer.IndexerClusterResource;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Indexer/Overview", description="Indexing overview")
@Path(value="/system/indexer/overview")
public class IndexerOverviewResource
extends RestResource {
    private final DeflectorResource deflectorResource;
    private final IndexerClusterResource indexerClusterResource;
    private final IndexRangesResource indexRangesResource;
    private final CountResource countResource;
    private final IndexSetRegistry indexSetRegistry;
    private final Indices indices;
    private final Cluster cluster;

    @Inject
    public IndexerOverviewResource(DeflectorResource deflectorResource, IndexerClusterResource indexerClusterResource, IndexRangesResource indexRangesResource, CountResource countResource, IndexSetRegistry indexSetRegistry, Indices indices, Cluster cluster) {
        this.deflectorResource = deflectorResource;
        this.indexerClusterResource = indexerClusterResource;
        this.indexRangesResource = indexRangesResource;
        this.countResource = countResource;
        this.indexSetRegistry = indexSetRegistry;
        this.indices = indices;
        this.cluster = cluster;
    }

    @GET
    @Timed
    @ApiOperation(value="Get overview of current indexing state, including deflector config, cluster state, index ranges & message counts.")
    @Produces(value={"application/json"})
    @Deprecated
    public IndexerOverview index() throws TooManyAliasesException {
        if (!this.cluster.isConnected()) {
            throw new ServiceUnavailableException("Elasticsearch cluster is not available, check your configuration and logs for more information.");
        }
        try {
            return this.getIndexerOverview(this.indexSetRegistry.getDefault());
        }
        catch (IllegalStateException e) {
            throw new NotFoundException("Default index set not found");
        }
    }

    @GET
    @Timed
    @Path(value="/{indexSetId}")
    @ApiOperation(value="Get overview of current indexing state for the given index set, including deflector config, cluster state, index ranges & message counts.")
    @Produces(value={"application/json"})
    public IndexerOverview index(@ApiParam(name="indexSetId") @PathParam(value="indexSetId") String indexSetId) throws TooManyAliasesException {
        if (!this.cluster.isConnected()) {
            throw new ServiceUnavailableException("Elasticsearch cluster is not available, check your configuration and logs for more information.");
        }
        IndexSet indexSet = this.getIndexSet(this.indexSetRegistry, indexSetId);
        return this.getIndexerOverview(indexSet);
    }

    private IndexerOverview getIndexerOverview(IndexSet indexSet) throws TooManyAliasesException {
        String indexSetId = indexSet.getConfig().id();
        DeflectorSummary deflectorSummary = this.deflectorResource.deflector(indexSetId);
        List<IndexRangeSummary> indexRanges = this.indexRangesResource.list().ranges();
        Map<String, IndexStats> allDocCounts = this.indices.getAllDocCounts(indexSet).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, Boolean> areReopened = this.indices.areReopened(allDocCounts.keySet());
        Map<String, IndexSummary> indicesSummaries = ((Stream)allDocCounts.values().stream().parallel()).collect(Collectors.toMap(IndexStats::getIndex, indexStats -> IndexSummary.create(IndexSizeSummary.create(indexStats.getPrimaries().getDocs().getCount(), indexStats.getPrimaries().getDocs().getDeleted(), indexStats.getPrimaries().getStore().sizeInBytes()), indexRanges.stream().filter(indexRangeSummary -> indexRangeSummary.indexName().equals(indexStats.getIndex())).findFirst().orElse(null), deflectorSummary.currentTarget() != null && deflectorSummary.currentTarget().equals(indexStats.getIndex()), false, (Boolean)areReopened.get(indexStats.getIndex()))));
        this.indices.getClosedIndices(indexSet).forEach(indexName -> indicesSummaries.put((String)indexName, IndexSummary.create(null, indexRanges.stream().filter(indexRangeSummary -> indexRangeSummary.indexName().equals(indexName)).findFirst().orElse(null), deflectorSummary.currentTarget() != null && deflectorSummary.equals(indexName), true, false)));
        return IndexerOverview.create(deflectorSummary, IndexerClusterOverview.create(this.indexerClusterResource.clusterHealth(), this.indexerClusterResource.clusterName().name()), this.countResource.total(indexSetId), indicesSummaries);
    }
}

