/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import io.searchbox.core.search.aggregation.CardinalityAggregation;
import io.searchbox.core.search.aggregation.ExtendedStatsAggregation;
import io.searchbox.core.search.aggregation.ValueCountAggregation;
import java.util.List;
import org.graylog2.indexer.results.IndexQueryResult;
import org.graylog2.indexer.results.ResultMessage;

public class FieldStatsResult
extends IndexQueryResult {
    private List<ResultMessage> searchHits;
    private final long count;
    private final double sum;
    private final double sumOfSquares;
    private final double mean;
    private final double min;
    private final double max;
    private final double variance;
    private final double stdDeviation;
    private final long cardinality;

    public FieldStatsResult(ValueCountAggregation valueCountAggregation, ExtendedStatsAggregation extendedStatsAggregation, CardinalityAggregation cardinalityAggregation, List<ResultMessage> hits, String query, String source, long tookMs) {
        super(query, source, tookMs);
        this.count = this.getValueCount(valueCountAggregation, extendedStatsAggregation);
        long l = this.cardinality = cardinalityAggregation == null ? Long.MIN_VALUE : cardinalityAggregation.getCardinality();
        if (extendedStatsAggregation != null) {
            this.sum = extendedStatsAggregation.getSum();
            this.sumOfSquares = extendedStatsAggregation.getSumOfSquares();
            this.mean = extendedStatsAggregation.getAvg();
            this.min = extendedStatsAggregation.getMin();
            this.max = extendedStatsAggregation.getMax();
            this.variance = extendedStatsAggregation.getVariance();
            this.stdDeviation = extendedStatsAggregation.getStdDeviation();
        } else {
            this.sum = Double.NaN;
            this.sumOfSquares = Double.NaN;
            this.mean = Double.NaN;
            this.min = Double.NaN;
            this.max = Double.NaN;
            this.variance = Double.NaN;
            this.stdDeviation = Double.NaN;
        }
        this.searchHits = hits;
    }

    private FieldStatsResult(String query, String bytesReference) {
        super(query, bytesReference, 0L);
        this.count = Long.MIN_VALUE;
        this.cardinality = Long.MIN_VALUE;
        this.sum = Double.NaN;
        this.sumOfSquares = Double.NaN;
        this.mean = Double.NaN;
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.variance = Double.NaN;
        this.stdDeviation = Double.NaN;
    }

    private long getValueCount(ValueCountAggregation valueCountAggregation, ExtendedStatsAggregation extendedStatsAggregation) {
        if (valueCountAggregation != null) {
            return valueCountAggregation.getValueCount();
        }
        if (extendedStatsAggregation != null) {
            return extendedStatsAggregation.getCount();
        }
        return Long.MIN_VALUE;
    }

    public long getCount() {
        return this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    public double getMean() {
        return this.mean;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getVariance() {
        return this.variance;
    }

    public double getStdDeviation() {
        return this.stdDeviation;
    }

    public long getCardinality() {
        return this.cardinality;
    }

    public List<ResultMessage> getSearchHits() {
        return this.searchHits;
    }

    public static FieldStatsResult empty(String query, String bytesReference) {
        return new FieldStatsResult(query, bytesReference);
    }
}

