/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import io.searchbox.core.search.aggregation.Bucket;
import io.searchbox.core.search.aggregation.TermsAggregation;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog2.indexer.results.IndexQueryResult;

public class TermsResult
extends IndexQueryResult {
    private final long total;
    private final long missing;
    private final long other;
    private final Map<String, Long> terms;

    public TermsResult(TermsAggregation terms, long missingCount, long totalCount, String originalQuery, String builtQuery, long tookMs) {
        super(originalQuery, builtQuery, tookMs);
        this.total = totalCount;
        this.missing = missingCount;
        this.other = terms.getSumOtherDocCount();
        this.terms = terms.getBuckets().stream().collect(Collectors.toMap(TermsAggregation.Entry::getKey, Bucket::getCount));
    }

    private TermsResult(String originalQuery, String builtQuery) {
        super(originalQuery, builtQuery, 0L);
        this.total = 0L;
        this.missing = 0L;
        this.other = 0L;
        this.terms = Collections.emptyMap();
    }

    public static TermsResult empty(String originalQuery, String builtQuery) {
        return new TermsResult(originalQuery, builtQuery);
    }

    public long getTotal() {
        return this.total;
    }

    public long getMissing() {
        return this.missing;
    }

    public long getOther() {
        return this.other;
    }

    public Map<String, Long> getTerms() {
        return this.terms;
    }
}

