/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup;

import com.google.common.collect.Streams;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog2.lookup.;
import org.graylog2.lookup.LookupDefaultMultiValue;
import org.graylog2.lookup.LookupDefaultSingleValue;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupCacheKey;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupResult;

public abstract class LookupTable {
    @Nullable
    public abstract String id();

    public abstract String title();

    public abstract String description();

    public abstract String name();

    public abstract LookupCache cache();

    public abstract LookupDataAdapter dataAdapter();

    public abstract LookupDefaultSingleValue defaultSingleValue();

    public abstract LookupDefaultMultiValue defaultMultiValue();

    public static Builder builder() {
        return new .AutoValue_LookupTable.Builder();
    }

    @Nullable
    public String error() {
        return Streams.concat((Stream[])new Stream[]{Streams.stream(this.dataAdapter().getError()), Streams.stream(this.cache().getError())}).map(Throwable::getMessage).collect(Collectors.joining("\n"));
    }

    @Nullable
    public LookupResult lookup(@Nonnull Object key) {
        LookupResult result = this.cache().get(LookupCacheKey.create(this.dataAdapter(), key), () -> this.dataAdapter().get(key));
        if (result.isEmpty()) {
            return LookupResult.withDefaults(this.defaultSingleValue(), this.defaultMultiValue());
        }
        return result;
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder title(String var1);

        public abstract Builder description(String var1);

        public abstract Builder name(String var1);

        public abstract Builder cache(LookupCache var1);

        public abstract Builder dataAdapter(LookupDataAdapter var1);

        public abstract Builder defaultSingleValue(LookupDefaultSingleValue var1);

        public abstract Builder defaultMultiValue(LookupDefaultMultiValue var1);

        public abstract LookupTable build();
    }
}

